/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.ArtifactTypeUtil;
import com.android.build.gradle.internal.scope.ProducersMap;
import com.android.build.gradle.internal.scope.ProducersMap$WhenMappings;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002 !B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0000J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0018\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0014J\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/scope/ProducersMap;", "T", "Lorg/gradle/api/file/FileSystemLocation;", "", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "identifier", "Lkotlin/Function0;", "", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/DirectoryProperty;Lkotlin/jvm/functions/Function0;)V", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "getIdentifier", "()Lkotlin/jvm/functions/Function0;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "producersMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/build/api/artifact/ArtifactType;", "Lcom/android/build/gradle/internal/scope/ProducersMap$Producers;", "copy", "", "artifactType", "source", "getProducers", "hasProducers", "", "republish", "from", "to", "Producer", "Producers", "gradle"})
public final class ProducersMap<T extends FileSystemLocation> {
    private final ConcurrentHashMap<ArtifactType, Producers<T>> producersMap;
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final DirectoryProperty buildDirectory;
    @NotNull
    private final Function0<String> identifier;

    public final boolean hasProducers(@NotNull ArtifactType artifactType) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        return this.producersMap.containsKey(artifactType);
    }

    @NotNull
    public final Producers<T> getProducers(@NotNull ArtifactType artifactType) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        ConcurrentMap $this$getOrPut$iv = this.producersMap;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(artifactType);
        if (object == null) {
            Class<Directory> clazz;
            Provider provider;
            boolean bl = false;
            switch (ProducersMap$WhenMappings.$EnumSwitchMapping$0[artifactType.kind().ordinal()]) {
                case 1: {
                    provider = this.buildDirectory.dir("__EMPTY_DIR__");
                    break;
                }
                case 2: {
                    provider = this.buildDirectory.file("__EMPTY_FILE__");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (provider == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.provider.Provider<T>");
            }
            switch (ProducersMap$WhenMappings.$EnumSwitchMapping$1[artifactType.kind().ordinal()]) {
                case 1: {
                    clazz = Directory.class;
                    break;
                }
                case 2: {
                    clazz = RegularFile.class;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ListProperty listProperty = this.objectFactory.listProperty(clazz);
            Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"objectFactory.listProper\u2026           } as Class<T>)");
            ListProperty listProperty2 = this.objectFactory.listProperty(Provider.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)listProperty2, (String)"objectFactory.listProper\u2026va as Class<Provider<T>>)");
            Producers producers = new Producers(artifactType, this.identifier, this.buildDirectory, provider, listProperty, listProperty2);
            boolean bl2 = false;
            boolean bl3 = false;
            Producers default$iv = producers;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(artifactType, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Producers)object;
    }

    public final void republish(@NotNull ArtifactType from, @NotNull ArtifactType to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        ((Map)this.producersMap).put(to, this.getProducers(from));
    }

    public final void copy(@NotNull ArtifactType artifactType, @NotNull ProducersMap<? extends FileSystemLocation> source) {
        Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
        Intrinsics.checkParameterIsNotNull(source, (String)"source");
        Producers<? extends FileSystemLocation> producers = source.getProducers(artifactType);
        if (producers == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.scope.ProducersMap.Producers<T>");
        }
        ((Map)this.producersMap).put(artifactType, producers);
    }

    @NotNull
    public final ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @NotNull
    public final DirectoryProperty getBuildDirectory() {
        return this.buildDirectory;
    }

    @NotNull
    public final Function0<String> getIdentifier() {
        return this.identifier;
    }

    public ProducersMap(@NotNull ObjectFactory objectFactory, @NotNull DirectoryProperty buildDirectory, @NotNull Function0<String> identifier) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)buildDirectory, (String)"buildDirectory");
        Intrinsics.checkParameterIsNotNull(identifier, (String)"identifier");
        this.objectFactory = objectFactory;
        this.buildDirectory = buildDirectory;
        this.identifier = identifier;
        this.producersMap = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004`\u0005BS\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010\u0012\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e0\u0010\u00a2\u0006\u0002\u0010\u0012J8\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010'2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010'0\u000e2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nJ\b\u0010+\u001a\u00020%H\u0016J\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010J\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000eJ\u0006\u0010.\u001a\u00020/J\u001a\u00100\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004J\u0014\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e03H\u0002J\u000e\u00104\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000e0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/build/gradle/internal/scope/ProducersMap$Producers;", "T", "Lorg/gradle/api/file/FileSystemLocation;", "Ljava/util/ArrayList;", "Lcom/android/build/gradle/internal/scope/ProducersMap$Producer;", "Lkotlin/collections/ArrayList;", "artifactType", "Lcom/android/build/api/artifact/ArtifactType;", "identifier", "Lkotlin/Function0;", "", "buildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "emptyProvider", "Lorg/gradle/api/provider/Provider;", "listProperty", "Lorg/gradle/api/provider/ListProperty;", "dependencies", "(Lcom/android/build/api/artifact/ArtifactType;Lkotlin/jvm/functions/Function0;Lorg/gradle/api/file/DirectoryProperty;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/ListProperty;Lorg/gradle/api/provider/ListProperty;)V", "getArtifactType", "()Lcom/android/build/api/artifact/ArtifactType;", "buildDir", "Ljava/io/File;", "getBuildDir", "()Ljava/io/File;", "getBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "getDependencies", "()Lorg/gradle/api/provider/ListProperty;", "getIdentifier", "()Lkotlin/jvm/functions/Function0;", "injectable", "getInjectable", "()Lorg/gradle/api/provider/Provider;", "lastProducerTaskName", "getLastProducerTaskName", "add", "", "settableProperty", "Lorg/gradle/api/provider/Property;", "originalProperty", "taskName", "fileName", "clear", "getAllProducers", "getCurrent", "hasMultipleProducers", "", "resolve", "producer", "resolveAll", "", "resolveAllAndReturnLast", "gradle"})
    public static final class Producers<T extends FileSystemLocation>
    extends ArrayList<Producer<T>> {
        @NotNull
        private final File buildDir;
        @NotNull
        private final Provider<T> injectable;
        @NotNull
        private final Provider<String> lastProducerTaskName;
        @NotNull
        private final ArtifactType artifactType;
        @NotNull
        private final Function0<String> identifier;
        @NotNull
        private final DirectoryProperty buildDirectory;
        private final Provider<T> emptyProvider;
        private final ListProperty<T> listProperty;
        @NotNull
        private final ListProperty<Provider<T>> dependencies;

        @NotNull
        public final File getBuildDir() {
            return this.buildDir;
        }

        @NotNull
        public final Provider<T> getInjectable() {
            return this.injectable;
        }

        @NotNull
        public final Provider<String> getLastProducerTaskName() {
            return this.lastProducerTaskName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final List<Provider<T>> resolveAll() {
            List list;
            Producers producers = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (producers) {
                void $this$mapTo$iv$iv;
                boolean bl3 = false;
                boolean multipleProducers = this.hasMultipleProducers();
                Producers $this$map$iv = this;
                boolean $i$f$map = false;
                Producers producers2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Producer producer = (Producer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    Provider provider = it.resolve(this.buildDir, this.identifier, this.artifactType, multipleProducers);
                    collection.add(provider);
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        @Nullable
        public final Provider<T> resolveAllAndReturnLast() {
            return (Provider)CollectionsKt.lastOrNull(this.resolveAll());
        }

        public final void add(@NotNull Property<T> settableProperty, @NotNull Provider<Property<T>> originalProperty, @NotNull String taskName, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(settableProperty, (String)"settableProperty");
            Intrinsics.checkParameterIsNotNull(originalProperty, (String)"originalProperty");
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.listProperty.add(originalProperty.map((Transformer)add.1.INSTANCE));
            this.dependencies.add(originalProperty);
            this.add(new Producer<T>(settableProperty, originalProperty, taskName, fileName));
        }

        @Override
        public void clear() {
            super.clear();
            this.listProperty.empty();
        }

        @Nullable
        public final Provider<T> getCurrent() {
            Producer producer = (Producer)CollectionsKt.lastOrNull((List)this);
            if (producer == null) {
                return null;
            }
            Producer currentProduct = producer;
            return currentProduct.resolve(this.buildDir, this.identifier, this.artifactType, this.hasMultipleProducers());
        }

        @NotNull
        public final ListProperty<T> getAllProducers() {
            return this.listProperty;
        }

        @NotNull
        public final Provider<T> resolve(@NotNull Producer<T> producer) {
            Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
            return producer.resolve(this.buildDir, this.identifier, this.artifactType, this.hasMultipleProducers());
        }

        public final boolean hasMultipleProducers() {
            return this.size() > 1;
        }

        @NotNull
        public final ArtifactType getArtifactType() {
            return this.artifactType;
        }

        @NotNull
        public final Function0<String> getIdentifier() {
            return this.identifier;
        }

        @NotNull
        public final DirectoryProperty getBuildDirectory() {
            return this.buildDirectory;
        }

        @NotNull
        public final ListProperty<Provider<T>> getDependencies() {
            return this.dependencies;
        }

        public Producers(@NotNull ArtifactType artifactType, @NotNull Function0<String> identifier, @NotNull DirectoryProperty buildDirectory, @NotNull Provider<T> emptyProvider, @NotNull ListProperty<T> listProperty, @NotNull ListProperty<Provider<T>> dependencies) {
            Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
            Intrinsics.checkParameterIsNotNull(identifier, (String)"identifier");
            Intrinsics.checkParameterIsNotNull((Object)buildDirectory, (String)"buildDirectory");
            Intrinsics.checkParameterIsNotNull(emptyProvider, (String)"emptyProvider");
            Intrinsics.checkParameterIsNotNull(listProperty, (String)"listProperty");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            this.artifactType = artifactType;
            this.identifier = identifier;
            this.buildDirectory = buildDirectory;
            this.emptyProvider = emptyProvider;
            this.listProperty = listProperty;
            this.dependencies = dependencies;
            Object object = this.buildDirectory.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"buildDirectory.get()");
            File file = ((Directory)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildDirectory.get().asFile");
            this.buildDir = file;
            Provider provider = this.dependencies.flatMap(new Transformer<Provider<? extends S>, List<T>>(this){
                final /* synthetic */ Producers this$0;

                @NotNull
                public final Provider<T> transform(List<Provider<T>> it) {
                    Provider provider = this.this$0.resolveAllAndReturnLast();
                    if (provider == null) {
                        provider = Producers.access$getEmptyProvider$p(this.this$0);
                    }
                    return provider;
                }
                {
                    this.this$0 = producers;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"dependencies.flatMap {\n \u2026ptyProvider\n            }");
            this.injectable = provider;
            Provider provider2 = this.injectable.map(new Transformer<S, T>(this){
                final /* synthetic */ Producers this$0;

                @NotNull
                public final String transform(T $noName_0) {
                    return ((Producer)this.this$0.get(this.this$0.size() - 1)).getTaskName();
                }
                {
                    this.this$0 = producers;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"injectable.map { _ -> get(size - 1).taskName }");
            this.lastProducerTaskName = provider2;
        }

        public static final /* synthetic */ Provider access$getEmptyProvider$p(Producers $this) {
            return $this.emptyProvider;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B7\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/scope/ProducersMap$Producer;", "T", "", "settableLocation", "Lorg/gradle/api/provider/Property;", "originalProperty", "Lorg/gradle/api/provider/Provider;", "taskName", "", "fileName", "(Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Provider;Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getTaskName", "resolve", "buildDir", "Ljava/io/File;", "identifier", "Lkotlin/Function0;", "artifactType", "Lcom/android/build/api/artifact/ArtifactType;", "multipleProducers", "", "gradle"})
    public static final class Producer<T> {
        private final Property<T> settableLocation;
        private final Provider<Property<T>> originalProperty;
        @NotNull
        private final String taskName;
        @NotNull
        private final String fileName;

        @NotNull
        public final Provider<T> resolve(@NotNull File buildDir, @NotNull Function0<String> identifier, @NotNull ArtifactType artifactType, boolean multipleProducers) {
            Intrinsics.checkParameterIsNotNull((Object)buildDir, (String)"buildDir");
            Intrinsics.checkParameterIsNotNull(identifier, (String)"identifier");
            Intrinsics.checkParameterIsNotNull((Object)artifactType, (String)"artifactType");
            File fileLocation = FileUtils.join((File)ArtifactTypeUtil.getOutputDir(artifactType, buildDir), (String[])new String[]{(String)identifier.invoke(), multipleProducers ? this.taskName : "", this.fileName});
            Property<T> property = this.settableLocation;
            if (property instanceof DirectoryProperty) {
                ((DirectoryProperty)this.settableLocation).set(fileLocation);
            } else if (property instanceof RegularFileProperty) {
                ((RegularFileProperty)this.settableLocation).set(fileLocation);
            } else {
                throw (Throwable)new RuntimeException("Property.get() is not a correct instance type : " + this.settableLocation.getClass().getName());
            }
            Object object = this.originalProperty.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"originalProperty.get()");
            return (Provider)object;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public Producer(@NotNull Property<T> settableLocation, @NotNull Provider<Property<T>> originalProperty, @NotNull String taskName, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull(settableLocation, (String)"settableLocation");
            Intrinsics.checkParameterIsNotNull(originalProperty, (String)"originalProperty");
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            this.settableLocation = settableLocation;
            this.originalProperty = originalProperty;
            this.taskName = taskName;
            this.fileName = fileName;
        }
    }
}

