/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.builder.model.TestOptions;
import com.android.utils.HelpfulEnumConverter;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.util.ConfigureUtil;

public class TestOptions {
    private static final HelpfulEnumConverter<TestOptions.Execution> EXECUTION_CONVERTER = new HelpfulEnumConverter(TestOptions.Execution.class);
    private String resultsDir;
    private String reportDir;
    private boolean animationsDisabled;
    private TestOptions.Execution execution = TestOptions.Execution.HOST;
    private final UnitTestOptions unitTests;

    @Inject
    public TestOptions(ObjectFactory objectFactory) {
        this.unitTests = (UnitTestOptions)objectFactory.newInstance(UnitTestOptions.class, new Object[0]);
    }

    public void unitTests(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.unitTests);
    }

    public UnitTestOptions getUnitTests() {
        return this.unitTests;
    }

    public String getResultsDir() {
        return this.resultsDir;
    }

    public void setResultsDir(String resultsDir) {
        this.resultsDir = resultsDir;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    public boolean getAnimationsDisabled() {
        return this.animationsDisabled;
    }

    public void setAnimationsDisabled(boolean animationsDisabled) {
        this.animationsDisabled = animationsDisabled;
    }

    public String getExecution() {
        return (String)Verify.verifyNotNull((Object)EXECUTION_CONVERTER.reverse().convert((Object)this.execution), (String)"No string representation for enum.", (Object[])new Object[0]);
    }

    public TestOptions.Execution getExecutionEnum() {
        return this.execution;
    }

    public void setExecution(String execution) {
        this.execution = (TestOptions.Execution)Preconditions.checkNotNull((Object)EXECUTION_CONVERTER.convert((Object)execution), (Object)"The value of `execution` cannot be null.");
    }

    public static class UnitTestOptions {
        private DomainObjectSet<Test> testTasks = new DefaultDomainObjectSet(Test.class);
        private boolean returnDefaultValues;
        private boolean includeAndroidResources;

        public boolean isReturnDefaultValues() {
            return this.returnDefaultValues;
        }

        public void setReturnDefaultValues(boolean returnDefaultValues) {
            this.returnDefaultValues = returnDefaultValues;
        }

        public boolean isIncludeAndroidResources() {
            return this.includeAndroidResources;
        }

        public void setIncludeAndroidResources(boolean includeAndroidResources) {
            this.includeAndroidResources = includeAndroidResources;
        }

        public void all(final Closure<Test> configClosure) {
            this.testTasks.all((Action)new Action<Test>(){

                public void execute(Test testTask) {
                    ConfigureUtil.configure((Closure)configClosure, (Object)testTask);
                }
            });
        }

        public void applyConfiguration(Test task) {
            this.testTasks.add((Object)task);
        }
    }
}

