/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.GradleBuildLoggingEnvironment;
import com.android.build.gradle.internal.cxx.configure.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.configure.ThreadLoggingEnvironment;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a%\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a'\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0013\u001a'\u0010\u0014\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0013\u001a\b\u0010\u0015\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a'\u0010\u0017\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"J\u0010\u0006\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \t*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b0\b \t*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003 \t*\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"BOTTOM_LOGGING_ENVIRONMENT", "Lcom/android/build/gradle/internal/cxx/configure/GradleBuildLoggingEnvironment;", "logger", "Lcom/android/build/gradle/internal/cxx/configure/ThreadLoggingEnvironment;", "getLogger", "()Lcom/android/build/gradle/internal/cxx/configure/ThreadLoggingEnvironment;", "loggerStack", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "checkedFormat", "", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "error", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "info", "pop", "push", "warn", "gradle"})
public final class LoggingEnvironmentKt {
    private static final ThreadLocal<List<ThreadLoggingEnvironment>> loggerStack = ThreadLocal.withInitial(loggerStack.1.INSTANCE);
    private static final GradleBuildLoggingEnvironment BOTTOM_LOGGING_ENVIRONMENT;

    private static final ThreadLoggingEnvironment getLogger() {
        List<ThreadLoggingEnvironment> list = loggerStack.get();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"loggerStack.get()");
        ThreadLoggingEnvironment threadLoggingEnvironment = (ThreadLoggingEnvironment)CollectionsKt.firstOrNull(list);
        if (threadLoggingEnvironment == null) {
            threadLoggingEnvironment = BOTTOM_LOGGING_ENVIRONMENT;
        }
        return threadLoggingEnvironment;
    }

    public static final void error(@NotNull String format, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        LoggingEnvironmentKt.getLogger().error(LoggingEnvironmentKt.checkedFormat(format, args2));
    }

    public static final void warn(@NotNull String format, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        LoggingEnvironmentKt.getLogger().warn(LoggingEnvironmentKt.checkedFormat(format, args2));
    }

    public static final void info(@NotNull String format, Object ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        LoggingEnvironmentKt.getLogger().info(LoggingEnvironmentKt.checkedFormat(format, args2));
    }

    private static final String checkedFormat(String format, Object[] args2) {
        try {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args2, args2.length);
            boolean bl = false;
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            return string;
        }
        catch (Throwable e) {
            StringBuilder stringBuilder = new StringBuilder().append("\n            ").append(e.getMessage()).append("\n            format = ").append(format).append("\n            args[").append(args2.length).append("] = ").append(ArraysKt.joinToString$default((Object[])args2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append("\n            stacktrace = ");
            Object[] objectArray = e.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"e.stackTrace");
            String string = StringsKt.trimIndent((String)stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
            boolean bl = false;
            System.out.println((Object)string);
            throw e;
        }
    }

    private static final void push(ThreadLoggingEnvironment logger) {
        loggerStack.get().add(0, logger);
    }

    private static final ThreadLoggingEnvironment pop() {
        return loggerStack.get().remove(0);
    }

    static {
        Logger logger = Logging.getLogger(GradleBuildLoggingEnvironment.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(Gradle\u2026gEnvironment::class.java)");
        BOTTOM_LOGGING_ENVIRONMENT = new GradleBuildLoggingEnvironment(logger, null, 2, null);
    }

    public static final /* synthetic */ ThreadLoggingEnvironment access$pop() {
        return LoggingEnvironmentKt.pop();
    }

    public static final /* synthetic */ void access$push(ThreadLoggingEnvironment logger) {
        LoggingEnvironmentKt.push(logger);
    }
}

