/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.model.Version;
import com.android.builder.sdk.DefaultSdkLoader;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.PlatformLoader;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;

public class SdkHandler {
    public static File sTestSdkFolder;
    private static final Object LOCK_FOR_SDK_HANDLER;
    private static SdkLoader sSdkLoader;
    private final ILogger logger;
    private SdkLoader sdkLoader;
    private File sdkFolder;
    private File ndkFolder;
    private File cmakePathInLocalProp = null;
    private SdkLibData sdkLibData = SdkLibData.dontDownload();
    private boolean isRegularSdk = true;
    private static final Pattern PATTERN_FIND_QUOTES;

    public static void setTestSdkFolder(File testSdkFolder) {
        sTestSdkFolder = testSdkFolder;
    }

    public static boolean useCachedSdk(ProjectOptions projectOptions) {
        return projectOptions.getOptionalCompilationSteps().contains(OptionalCompilationStep.INSTANT_DEV) && SyncOptions.getModelQueryMode(projectOptions) == SyncOptions.EvaluationMode.STANDARD;
    }

    public SdkHandler(Project project, ILogger logger) {
        this.logger = logger;
        this.findLocation(project);
    }

    public SdkInfo getSdkInfo() {
        SdkLoader sdkLoader = this.getSdkLoader();
        return sdkLoader.getSdkInfo(this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initTarget(String targetHash, Revision buildToolRevision, Collection<LibraryRequest> usedLibraries, AndroidBuilder androidBuilder, boolean useCachedVersion) {
        TargetInfo targetInfo;
        Preconditions.checkNotNull((Object)targetHash, (Object)"android.compileSdkVersion is missing!");
        Preconditions.checkNotNull((Object)buildToolRevision, (Object)"android.buildToolsVersion is missing!");
        Object object = LOCK_FOR_SDK_HANDLER;
        synchronized (object) {
            if (useCachedVersion) {
                if (sSdkLoader == null) {
                    this.logger.verbose("Parsing the Sdk", new Object[0]);
                    sSdkLoader = this.getSdkLoader();
                } else {
                    this.logger.verbose("Reusing the SdkLoader", new Object[0]);
                }
            } else {
                this.logger.verbose("Parsing the SDK, no caching allowed", new Object[0]);
                sSdkLoader = this.getSdkLoader();
            }
            this.sdkLoader = sSdkLoader;
        }
        if (buildToolRevision.compareTo(AndroidBuilder.MIN_BUILD_TOOLS_REV) < 0) {
            androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.BUILD_TOOLS_TOO_LOW, String.format("The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.", buildToolRevision, AndroidBuilder.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION), AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION.toString());
            buildToolRevision = AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SdkInfo sdkInfo = this.sdkLoader.getSdkInfo(this.logger);
        try {
            targetInfo = this.sdkLoader.getTargetInfo(targetHash, buildToolRevision, this.logger, this.sdkLibData);
        }
        catch (LicenceNotAcceptedException e) {
            androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, new EvalIssueException(e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" "))));
            return false;
        }
        catch (InstallFailedException e) {
            androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, new EvalIssueException(e.getMessage(), e.getAffectedPackages().stream().map(RepoPackage::getPath).collect(Collectors.joining(" "))));
            return false;
        }
        androidBuilder.setSdkInfo(sdkInfo);
        androidBuilder.setTargetInfo(targetInfo);
        androidBuilder.setLibraryRequests(usedLibraries);
        this.logger.verbose("SDK initialized in %1$d ms", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return true;
    }

    public void ensurePlatformToolsIsInstalledWarnOnFailure(EvalIssueReporter issueReporter) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)this.getSdkFolder());
        LocalPackage platformToolsPackage = sdk.getLatestLocalPackageForPrefix("platform-tools", null, true, (ProgressIndicator)progress);
        if (platformToolsPackage == null && this.sdkLoader != null) {
            if (this.sdkLibData.useSdkDownload()) {
                try {
                    this.sdkLoader.installSdkTool(this.sdkLibData, "platform-tools");
                }
                catch (LicenceNotAcceptedException e) {
                    issueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed. Please accept the installation licence to continue", "platform-tools");
                }
                catch (InstallFailedException e) {
                    issueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed, and automatic installation failed.", "platform-tools");
                }
            } else {
                issueReporter.reportWarning(EvalIssueReporter.Type.MISSING_SDK_PACKAGE, "platform-tools package is not installed.", "platform-tools");
            }
        }
    }

    public File getSdkFolder() {
        return this.sdkFolder;
    }

    public File getCmakePathInLocalProp() {
        return this.cmakePathInLocalProp;
    }

    public File checkAndGetSdkFolder() {
        if (this.sdkFolder == null) {
            throw new MissingSdkException("SDK location not found.");
        }
        return this.sdkFolder;
    }

    public synchronized SdkLoader getSdkLoader() {
        if (this.sdkLoader == null) {
            if (this.isRegularSdk) {
                this.checkAndGetSdkFolder();
                if (sTestSdkFolder == null && !this.sdkFolder.isDirectory()) {
                    throw new RuntimeException(String.format("The SDK directory '%1$s' does not exist.", this.sdkFolder));
                }
                this.sdkLoader = DefaultSdkLoader.getLoader((File)this.sdkFolder);
            } else {
                this.sdkLoader = PlatformLoader.getLoader((File)this.sdkFolder);
            }
        }
        return this.sdkLoader;
    }

    public synchronized void unload() {
        if (this.sdkLoader != null) {
            if (this.isRegularSdk) {
                DefaultSdkLoader.unload();
            } else {
                PlatformLoader.unload();
            }
            this.sdkLoader = null;
        }
    }

    public File getNdkFolder() {
        return this.ndkFolder;
    }

    public static Pair<File, Boolean> findSdkLocation(Properties properties, File rootDir) {
        String sdkDirProp = properties.getProperty("sdk.dir");
        if (sdkDirProp != null) {
            File sdk = new File(sdkDirProp);
            if (!sdk.isAbsolute()) {
                sdk = new File(rootDir, sdkDirProp);
            }
            return Pair.of((Object)sdk, (Object)true);
        }
        sdkDirProp = properties.getProperty("android.dir");
        if (sdkDirProp != null) {
            return Pair.of((Object)new File(rootDir, sdkDirProp), (Object)false);
        }
        String envVar = System.getenv("ANDROID_SDK_ROOT");
        if (envVar == null) {
            envVar = System.getenv("ANDROID_HOME");
        }
        if (envVar != null) {
            File sdk = new File(envVar);
            if (!sdk.isAbsolute()) {
                sdk = new File(rootDir, envVar);
            }
            return Pair.of((Object)sdk, (Object)true);
        }
        String property = System.getProperty("android.home");
        if (property != null) {
            return Pair.of((Object)new File(property), (Object)true);
        }
        return Pair.of(null, (Object)true);
    }

    /*
     * Loose catch block
     */
    private void findLocation(Project project) {
        Properties properties;
        File rootDir;
        block15: {
            if (sTestSdkFolder != null) {
                this.sdkFolder = sTestSdkFolder;
                return;
            }
            rootDir = project.getRootDir();
            File localProperties = new File(rootDir, "local.properties");
            properties = new Properties();
            if (localProperties.isFile()) {
                InputStreamReader reader = null;
                FileInputStream fis2232322322 = new FileInputStream(localProperties);
                reader = new InputStreamReader((InputStream)fis2232322322, Charsets.UTF_8);
                properties.load(reader);
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException fis2232322322) {}
                break block15;
                catch (FileNotFoundException fis2232322322) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException fis2232322322) {}
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Unable to read %1$s.", localProperties.getAbsolutePath()), e);
                    {
                        catch (Throwable throwable) {
                            try {
                                Closeables.close(reader, (boolean)true);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        Pair<File, Boolean> sdkLocation = SdkHandler.findSdkLocation(properties, rootDir);
        this.sdkFolder = (File)sdkLocation.getFirst();
        this.isRegularSdk = (Boolean)sdkLocation.getSecond();
        this.ndkFolder = NdkHandler.findNdkDirectory(properties, rootDir);
        String cmakeProperty = properties.getProperty("cmake.dir");
        if (cmakeProperty != null) {
            Matcher m = PATTERN_FIND_QUOTES.matcher(cmakeProperty);
            this.cmakePathInLocalProp = m.find() ? new File(m.group(1)) : new File(cmakeProperty);
        }
    }

    public void setSdkLibData(SdkLibData sdkLibData) {
        this.sdkLibData = sdkLibData;
    }

    public void installNdk(NdkHandler ndkHandler) {
        if (!this.sdkLibData.useSdkDownload()) {
            return;
        }
        try {
            this.ndkFolder = this.sdkLoader.installSdkTool(this.sdkLibData, "ndk-bundle");
        }
        catch (InstallFailedException | LicenceNotAcceptedException e) {
            throw new RuntimeException(e);
        }
        ndkHandler.relocateNdkFolder();
    }

    public void installCMake(String version) {
        if (!this.sdkLibData.useSdkDownload()) {
            return;
        }
        try {
            this.sdkLoader.installSdkTool(this.sdkLibData, "cmake;" + version);
        }
        catch (InstallFailedException | LicenceNotAcceptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void addLocalRepositories(Project project) {
        for (File repository : this.getSdkLoader().getRepositories()) {
            MavenArtifactRepository mavenRepository = project.getRepositories().maven(newRepository -> {
                newRepository.setName(repository.getPath());
                newRepository.setUrl((Object)repository);
            });
            project.getRepositories().remove((Object)mavenRepository);
            project.getRepositories().addFirst((ArtifactRepository)mavenRepository);
        }
    }

    public boolean checkResetCache() {
        return this.sdkLibData.needsCacheReset();
    }

    static {
        LOCK_FOR_SDK_HANDLER = new Object();
        PATTERN_FIND_QUOTES = Pattern.compile("\"([^\"]*)\"");
    }

    public static class MissingSdkException
    extends RuntimeException {
        public MissingSdkException(String message) {
            super(message);
        }

        public MissingSdkException(String message, Exception e) {
            super(message, e);
        }
    }
}

