/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.tasks.AnnotationProcessingTaskCreationAction;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.tools.ant.BuildException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public class ProcessLibraryManifest
extends ManifestProcessorTask {
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<Integer> maxSdkVersion;
    private VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration;
    private OutputScope outputScope;
    private final Provider<RegularFile> manifestOutputFile;

    @Inject
    public ProcessLibraryManifest(ObjectFactory objectFactory) {
        super(objectFactory);
        this.manifestOutputFile = objectFactory.fileProperty();
    }

    @OutputFile
    public Provider<RegularFile> getManifestOutputFile() {
        return this.manifestOutputFile;
    }

    @Override
    protected void doFullTaskAction() {
        File aaptFriendlyManifestOutputFile = this.getAaptFriendlyManifestOutputFile();
        MergingReport mergingReport = this.getBuilder().mergeManifestsForApplication(this.getMainManifest(), this.getManifestOverlays(), Collections.emptyList(), this.getNavigationFiles(), null, this.getPackageOverride(), this.getVersionCode(), this.getVersionName(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), ((RegularFile)this.manifestOutputFile.get()).getAsFile().getAbsolutePath(), aaptFriendlyManifestOutputFile != null ? aaptFriendlyManifestOutputFile.getAbsolutePath() : null, null, null, null, null, ManifestMerger2.MergeType.LIBRARY, this.variantConfiguration.getManifestPlaceholders(), Collections.emptyList(), this.getReportFile());
        XmlDocument mergedXmlDocument = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
        ImmutableMap properties = mergedXmlDocument != null ? ImmutableMap.of((Object)"packageId", (Object)mergedXmlDocument.getPackageName(), (Object)"split", (Object)mergedXmlDocument.getSplitName()) : ImmutableMap.of();
        try {
            if (this.getManifestOutputDirectory().isPresent()) {
                new BuildOutput((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, this.outputScope.getMainSplit(), ((RegularFile)this.manifestOutputFile.get()).getAsFile(), (Map<String, String>)properties).save(((Directory)this.getManifestOutputDirectory().get()).getAsFile());
            }
            if (this.getAaptFriendlyManifestOutputDirectory().isPresent()) {
                new BuildOutput((ArtifactType)InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS, this.outputScope.getMainSplit(), aaptFriendlyManifestOutputFile, (Map<String, String>)properties).save(((Directory)this.getAaptFriendlyManifestOutputDirectory().get()).getAsFile());
            }
        }
        catch (IOException e) {
            throw new BuildException("Exception while saving build metadata : ", (Throwable)e);
        }
    }

    @Override
    @Internal
    public File getAaptFriendlyManifestOutputFile() {
        Preconditions.checkNotNull((Object)this.outputScope.getMainSplit());
        return this.getAaptFriendlyManifestOutputDirectory().isPresent() ? FileUtils.join((File)((Directory)this.getAaptFriendlyManifestOutputDirectory().get()).getAsFile(), (String[])new String[]{this.outputScope.getMainSplit().getDirName(), "AndroidManifest.xml"}) : null;
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion.get();
    }

    @Internal
    public VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantConfiguration(VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getMainManifest() {
        return this.variantConfiguration.getMainManifest();
    }

    @Input
    @Optional
    public String getPackageOverride() {
        return this.variantConfiguration.getApplicationId();
    }

    @Input
    public int getVersionCode() {
        return this.variantConfiguration.getVersionCode();
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.variantConfiguration.getVersionName();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getManifestOverlays() {
        return this.variantConfiguration.getManifestOverlays();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getNavigationFiles() {
        return this.variantConfiguration.getNavigationFiles();
    }

    @Input
    @Optional
    public String getManifestPlaceholders() {
        return ProcessLibraryManifest.serializeMap(this.variantConfiguration.getManifestPlaceholders());
    }

    @Input
    public String getMainSplitFullName() {
        return this.outputScope.getMainSplit().getFullName();
    }

    public static class CreationAction
    extends AnnotationProcessingTaskCreationAction<ProcessLibraryManifest> {
        Provider<RegularFile> manifestOutputFile;
        Provider<Directory> manifestOutputDirectory;
        File aaptFriendlyManifestOutputDirectory;
        VariantScope scope;
        private File reportFile;

        public CreationAction(VariantScope scope) {
            super(scope, scope.getTaskName("process", "Manifest"), ProcessLibraryManifest.class);
            this.scope = scope;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.reportFile = FileUtils.join((File)this.getVariantScope().getGlobalScope().getOutputsDir(), (String[])new String[]{"logs", "manifest-merger-" + this.getVariantScope().getVariantConfiguration().getBaseName() + "-report.txt"});
            this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MANIFEST_MERGE_REPORT, (Collection<? extends Object>)ImmutableList.of((Object)this.reportFile), taskName);
        }

        @Override
        public void handleProvider(TaskProvider<? extends ProcessLibraryManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.scope.getTaskContainer().setProcessManifestTask(taskProvider);
            this.scope.getArtifacts().registerProducer(InternalArtifactType.AAPT_FRIENDLY_MERGED_MANIFESTS, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Provider<Provider<? extends FileSystemLocation>>)taskProvider.map(ManifestProcessorTask::getAaptFriendlyManifestOutputDirectory), "aapt");
            this.scope.getArtifacts().registerProducer(InternalArtifactType.MERGED_MANIFESTS, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Provider<Provider<? extends FileSystemLocation>>)taskProvider.map(ManifestProcessorTask::getManifestOutputDirectory), "");
            this.scope.getArtifacts().registerProducer(InternalArtifactType.LIBRARY_MANIFEST, BuildArtifactsHolder.OperationType.INITIAL, taskProvider, (Provider<Provider<? extends FileSystemLocation>>)taskProvider.map(ProcessLibraryManifest::getManifestOutputFile), "AndroidManifest.xml");
        }

        @Override
        public void configure(ProcessLibraryManifest task) {
            super.configure(task);
            task.checkManifestResult = this.getVariantScope().getArtifacts().getFinalArtifactFilesIfPresent(InternalArtifactType.CHECK_MANIFEST_RESULT);
            GradleVariantConfiguration config2 = this.getVariantScope().getVariantConfiguration();
            task.variantConfiguration = config2;
            ProductFlavor mergedFlavor = config2.getMergedFlavor();
            task.minSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion minSdkVersion1 = mergedFlavor.getMinSdkVersion();
                if (minSdkVersion1 == null) {
                    return null;
                }
                return minSdkVersion1.getApiString();
            });
            task.targetSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion targetSdkVersion = mergedFlavor.getTargetSdkVersion();
                if (targetSdkVersion == null) {
                    return null;
                }
                return targetSdkVersion.getApiString();
            });
            task.maxSdkVersion = TaskInputHelper.memoize(() -> ((ProductFlavor)mergedFlavor).getMaxSdkVersion());
            task.outputScope = this.getVariantScope().getOutputScope();
            task.setReportFile(this.reportFile);
        }
    }
}

