/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedFileContents;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class KnownFilesSaveData {
    private static final String SAVE_DATA_FILE_NAME = "file-input-save-data.txt";
    private static final String COUNT_PROPERTY = "count";
    private static final String BASE_SUFFIX = ".base";
    private static final String RELATIVE_PATH_SUFFIX = ".path";
    private static final String INPUT_SET_SUFFIX = ".set";
    private static final String BASE_TYPE_SUFFIX = ".baseType";
    private static final Map<File, CachedFileContents<KnownFilesSaveData>> mCache = Maps.newHashMap();
    private final CachedFileContents<KnownFilesSaveData> mFileContentsCache;
    private final Map<RelativeFile, InputSet> mFiles;
    private boolean mDirty;

    KnownFilesSaveData(CachedFileContents<KnownFilesSaveData> cache) throws IOException {
        this.mFileContentsCache = cache;
        this.mFiles = Maps.newHashMap();
        if (cache.getFile().isFile()) {
            this.readCurrentData();
        }
        this.mDirty = false;
    }

    public static synchronized KnownFilesSaveData make(File intermediateDir) throws IOException {
        KnownFilesSaveData saveData;
        File saveFile = KnownFilesSaveData.computeSaveFile(intermediateDir);
        CachedFileContents cached = mCache.get(saveFile);
        if (cached == null) {
            cached = new CachedFileContents(saveFile);
            mCache.put(saveFile, (CachedFileContents<KnownFilesSaveData>)cached);
        }
        if ((saveData = (KnownFilesSaveData)cached.getCache()) == null) {
            saveData = new KnownFilesSaveData((CachedFileContents<KnownFilesSaveData>)cached);
            cached.closed((Object)saveData);
        }
        return saveData;
    }

    private static File computeSaveFile(File intermediateDir) {
        return new File(intermediateDir, SAVE_DATA_FILE_NAME);
    }

    void readCurrentData() throws IOException {
        int fileCount;
        Closer closer = Closer.create();
        File saveFile = this.mFileContentsCache.getFile();
        Properties properties = new Properties();
        try {
            Reader saveDataReader = (Reader)closer.register((Closeable)new FileReader(saveFile));
            properties.load(saveDataReader);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        String fileCountText = null;
        try {
            fileCountText = properties.getProperty(COUNT_PROPERTY);
            if (fileCountText == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has no value).");
            }
            fileCount = Integer.parseInt(fileCountText);
            if (fileCount < 0) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has value " + fileCount + ").");
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + COUNT_PROPERTY + "' has value '" + fileCountText + "').", e);
        }
        for (int i = 0; i < fileCount; ++i) {
            InputSet is;
            RelativeFile.Type baseType;
            String baseName = properties.getProperty(i + BASE_SUFFIX);
            if (baseName == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + BASE_SUFFIX + "' has no value).");
            }
            String relativePath = properties.getProperty(i + RELATIVE_PATH_SUFFIX);
            if (relativePath == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + RELATIVE_PATH_SUFFIX + "' has no value).");
            }
            String inputSetName = properties.getProperty(i + INPUT_SET_SUFFIX);
            if (inputSetName == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + INPUT_SET_SUFFIX + "' has no value).");
            }
            String baseTypeString = properties.getProperty(i + BASE_TYPE_SUFFIX);
            if (baseTypeString == null) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + BASE_TYPE_SUFFIX + "' has no value).");
            }
            try {
                baseType = RelativeFile.Type.valueOf((String)baseTypeString);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + BASE_TYPE_SUFFIX + "' has value '" + baseTypeString + "').", e);
            }
            try {
                is = InputSet.valueOf(InputSet.class, inputSetName);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Invalid data stored in file '" + saveFile + "' (property '" + i + INPUT_SET_SUFFIX + "' has invalid value '" + inputSetName + "').");
            }
            this.mFiles.put(new RelativeFile(new File(baseName), relativePath, baseType), is);
        }
    }

    public void saveCurrentData() throws IOException {
        if (!this.mDirty) {
            return;
        }
        Closer closer = Closer.create();
        Properties properties = new Properties();
        properties.put(COUNT_PROPERTY, Integer.toString(this.mFiles.size()));
        int idx = 0;
        for (Map.Entry<RelativeFile, InputSet> e : this.mFiles.entrySet()) {
            RelativeFile rf = e.getKey();
            String basePath = (String)Verify.verifyNotNull((Object)rf.getBase().getPath());
            Verify.verify((!basePath.isEmpty() ? 1 : 0) != 0);
            String relativePath = (String)Verify.verifyNotNull((Object)rf.getRelativePath());
            Verify.verify((!relativePath.isEmpty() ? 1 : 0) != 0);
            properties.put(idx + BASE_SUFFIX, basePath);
            properties.put(idx + RELATIVE_PATH_SUFFIX, relativePath);
            properties.put(idx + INPUT_SET_SUFFIX, e.getValue().name());
            properties.put(idx + BASE_TYPE_SUFFIX, rf.getType().name());
            ++idx;
        }
        try {
            Writer saveDataWriter = (Writer)closer.register((Closeable)new FileWriter(this.mFileContentsCache.getFile()));
            properties.store(saveDataWriter, "Internal package file, do not edit.");
            this.mFileContentsCache.closed((Object)this);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    public ImmutableSet<RelativeFile> find(Set<File> files2, InputSet inputSet) {
        HashSet found = Sets.newHashSet();
        for (RelativeFile rf : Maps.filterValues(this.mFiles, (Predicate)Predicates.equalTo((Object)((Object)inputSet))).keySet()) {
            if (!files2.contains(new File(rf.getBase(), rf.getRelativePath()))) continue;
            found.add(rf);
        }
        return ImmutableSet.copyOf((Collection)found);
    }

    private java.util.function.Function<File, RelativeFile> inInputSet(InputSet inputSet) {
        Map inverseFiltered = this.mFiles.entrySet().stream().filter(e -> e.getValue() == inputSet).map(Map.Entry::getKey).collect(HashMap::new, (m, rf) -> m.put(new File(rf.getBase(), rf.getRelativePath()), rf), Map::putAll);
        return inverseFiltered::get;
    }

    public void setInputSet(Collection<RelativeFile> files2, InputSet set) {
        Iterator<Map.Entry<RelativeFile, InputSet>> it = this.mFiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<RelativeFile, InputSet> next = it.next();
            if (next.getValue() != set || files2.contains(next.getKey())) continue;
            it.remove();
            this.mDirty = true;
        }
        files2.forEach(f -> {
            if (!this.mFiles.containsKey(f) && f.getType() == RelativeFile.Type.DIRECTORY) {
                this.mFiles.put((RelativeFile)f, set);
                this.mDirty = true;
            }
        });
    }

    boolean isDirty() {
        return this.mDirty;
    }

    Map<RelativeFile, InputSet> getFiles() {
        return this.mFiles;
    }

    public static ImmutableMap<RelativeFile, FileStatus> getChangedInputs(Map<File, FileStatus> changedInputs, KnownFilesSaveData saveData, InputSet inputSet, Collection<File> baseFiles, FileCacheByPath cacheByPath, Set<Runnable> cacheUpdates) throws IOException {
        Set<File> deletedFiles = Maps.filterValues(changedInputs, (Predicate)Predicates.equalTo((Object)FileStatus.REMOVED)).keySet();
        ImmutableSet<RelativeFile> deletedRelativeFiles = saveData.find(deletedFiles, inputSet);
        Map nonDeletedFiles = Maps.filterValues(changedInputs, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)FileStatus.REMOVED)));
        ImmutableMap nonDeletedRelativeFiles = IncrementalRelativeFileSets.makeFromBaseFiles(baseFiles, (Map)nonDeletedFiles, (FileCacheByPath)cacheByPath, cacheUpdates, (IncrementalRelativeFileSets.FileDeletionPolicy)IncrementalRelativeFileSets.FileDeletionPolicy.DISALLOW_FILE_DELETIONS);
        return new ImmutableMap.Builder().putAll(Maps.asMap(deletedRelativeFiles, (Function)Functions.constant((Object)FileStatus.REMOVED))).putAll((Map)nonDeletedRelativeFiles).build();
    }

    public static enum InputSet {
        DEX,
        JAVA_RESOURCE,
        NATIVE_RESOURCE,
        ANDROID_RESOURCE,
        ASSET;

    }
}

