/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.D8MainDexListTransformKt;
import com.android.build.gradle.internal.transforms.MainDexListWriter;
import com.android.build.gradle.internal.transforms.ProguardInput;
import com.android.builder.multidex.D8MainDexList;
import com.android.ide.common.blame.MessageReceiver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007BK\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\"0!H\u0016J\u0010\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020%0$H\u0016J\u0010\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u00020%0\u001cH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\b\u0010-\u001a\u00020\u0006H\u0016J\b\u0010.\u001a\u00020\u0006H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020)H\u0016J\u0010\u00102\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/transforms/D8MainDexListTransform;", "Lcom/android/build/api/transform/Transform;", "Lcom/android/build/gradle/internal/transforms/MainDexListWriter;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "includeDynamicFeatures", "", "(Lcom/android/build/gradle/internal/scope/VariantScope;Z)V", "manifestProguardRules", "Lcom/android/build/api/artifact/BuildableArtifact;", "userProguardRules", "Ljava/nio/file/Path;", "userClasses", "bootClasspath", "Ljava/util/function/Supplier;", "", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "(Lcom/android/build/api/artifact/BuildableArtifact;Ljava/nio/file/Path;Ljava/nio/file/Path;ZLjava/util/function/Supplier;Lcom/android/ide/common/blame/MessageReceiver;)V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "outputMainDexList", "getByInputType", "", "Lcom/android/build/gradle/internal/transforms/ProguardInput;", "invocation", "Lcom/android/build/api/transform/TransformInvocation;", "getInputTypes", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getParameterInputs", "Lcom/google/common/collect/ImmutableMap;", "", "getReferencedScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "getSecondaryFileOutputs", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "getSecondaryFiles", "", "Lcom/android/build/api/transform/SecondaryFile;", "isCacheable", "isIncremental", "setMainDexListOutputFile", "", "mainDexListFile", "transform", "gradle"})
public final class D8MainDexListTransform
extends Transform
implements MainDexListWriter {
    private final LoggerWrapper logger;
    private Path outputMainDexList;
    private final BuildableArtifact manifestProguardRules;
    private final Path userProguardRules;
    private final Path userClasses;
    private final boolean includeDynamicFeatures;
    private final Supplier<List<Path>> bootClasspath;
    private final MessageReceiver messageReceiver;

    @Override
    public void setMainDexListOutputFile(@NotNull File mainDexListFile) {
        Intrinsics.checkParameterIsNotNull((Object)mainDexListFile, (String)"mainDexListFile");
        Path path = mainDexListFile.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"mainDexListFile.toPath()");
        this.outputMainDexList = path;
    }

    @NotNull
    public String getName() {
        return this.includeDynamicFeatures ? "bundleMultiDexList" : "multidexlist";
    }

    @NotNull
    public ImmutableSet<? extends QualifiedContent.ContentType> getInputTypes() {
        ImmutableSet immutableSet = Sets.immutableEnumSet((Enum)((Enum)QualifiedContent.DefaultContentType.CLASSES), (Enum[])new QualifiedContent.DefaultContentType[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"Sets.immutableEnumSet(Qu\u2026faultContentType.CLASSES)");
        return immutableSet;
    }

    @NotNull
    public ImmutableSet<? super QualifiedContent.Scope> getScopes() {
        ImmutableSet immutableSet = ImmutableSet.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of()");
        return immutableSet;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        ImmutableSet referenced = Sets.immutableEnumSet((Enum)((Enum)QualifiedContent.Scope.PROJECT), (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.TESTED_CODE});
        if (!this.includeDynamicFeatures) {
            ImmutableSet immutableSet = referenced;
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"referenced");
            return (Set)immutableSet;
        }
        Sets.SetView setView = Sets.union((Set)((Set)referenced), TransformManager.SCOPE_FEATURES);
        Intrinsics.checkExpressionValueIsNotNull((Object)setView, (String)"Sets.union(referenced, T\u2026rmManager.SCOPE_FEATURES)");
        return (Set)setView;
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        Path it;
        Path path;
        ImmutableList.Builder builder;
        ImmutableList.Builder $receiver = builder = ImmutableList.builder();
        $receiver.add((Object)SecondaryFile.nonIncremental((Supplier)((Supplier)this.manifestProguardRules)));
        Path path2 = this.userProguardRules;
        if (path2 != null) {
            it = path = path2;
            $receiver.add((Object)SecondaryFile.nonIncremental((File)it.toFile()));
        }
        Path path3 = this.userClasses;
        if (path3 != null) {
            it = path = path3;
            $receiver.add((Object)SecondaryFile.nonIncremental((File)it.toFile()));
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.builder<Se\u2026e())) }\n        }.build()");
        return (Collection)immutableList;
    }

    @NotNull
    public ImmutableList<File> getSecondaryFileOutputs() {
        Path path = this.outputMainDexList;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMainDexList");
        }
        ImmutableList immutableList = ImmutableList.of((Object)path.toFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(outputMainDexList.toFile())");
        return immutableList;
    }

    @NotNull
    public ImmutableMap<String, Object> getParameterInputs() {
        ImmutableMap immutableMap = ImmutableMap.of((Object)"implementation", (Object)D8MainDexListTransform.class.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.of(\"impleme\u2026ansform::class.java.name)");
        return immutableMap;
    }

    public void transform(@NotNull TransformInvocation invocation) {
        Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
        this.logger.verbose("Generating the main dex list using D8.", new Object[0]);
        try {
            Map<ProguardInput, List<Path>> inputs = this.getByInputType(invocation);
            List<Path> list = inputs.get((Object)ProguardInput.INPUT_JAR);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            List<Path> programFiles = list;
            List<Path> list2 = inputs.get((Object)ProguardInput.LIBRARY_JAR);
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            Collection collection = list2;
            List<Path> list3 = this.bootClasspath.get();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"bootClasspath.get()");
            List libraryFiles = CollectionsKt.plus((Collection)collection, (Iterable)list3);
            this.logger.verbose("Program files: %s", CollectionsKt.joinToString$default((Iterable)programFiles, null, null, null, (int)0, null, null, (int)63, null));
            this.logger.verbose("Library files: %s", CollectionsKt.joinToString$default((Iterable)libraryFiles, null, null, null, (int)0, null, null, (int)63, null));
            this.logger.verbose("Proguard rule files: %s", CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])new Iterable[]{(Iterable)this.manifestProguardRules, this.userProguardRules}), null, null, null, (int)0, null, null, (int)63, null));
            List proguardRules = CollectionsKt.listOfNotNull((Object[])new Path[]{BuildableArtifactUtil.singleFile(this.manifestProguardRules).toPath(), this.userProguardRules});
            Set mainDexClasses = new LinkedHashSet();
            List list4 = D8MainDexList.generate(D8MainDexListTransformKt.getPlatformRules(), (List)proguardRules, (Collection)programFiles, (Collection)libraryFiles, (MessageReceiver)this.messageReceiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"D8MainDexList.generate(\n\u2026eceiver\n                )");
            mainDexClasses.addAll(list4);
            if (this.userClasses != null) {
                List<String> list5 = Files.readAllLines(this.userClasses);
                Intrinsics.checkExpressionValueIsNotNull(list5, (String)"Files.readAllLines(userClasses)");
                mainDexClasses.addAll((Collection)list5);
            }
            Path path = this.outputMainDexList;
            if (path == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputMainDexList");
            }
            Files.deleteIfExists(path);
            Path path2 = this.outputMainDexList;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputMainDexList");
            }
            Files.write(path2, (Iterable<? extends CharSequence>)mainDexClasses, new OpenOption[0]);
        }
        catch (D8MainDexList.MainDexListException e) {
            throw (Throwable)new TransformException("Error while generating the main dex list:" + System.lineSeparator() + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ProguardInput, List<Path>> getByInputType(TransformInvocation invocation) {
        Path path;
        QualifiedContent it;
        Collection<Path> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Pair[] pairArray;
        void inputs;
        TransformInput it2;
        void $receiver$iv$iv2;
        Sequence $receiver$iv2;
        ImmutableSet libraryScopes = Sets.immutableEnumSet((Enum)((Enum)QualifiedContent.Scope.PROVIDED_ONLY), (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.TESTED_CODE});
        Collection collection2 = invocation.getReferencedInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"invocation.referencedInputs");
        Iterable iterable = collection2;
        void var7_4 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            TransformInput transformInput = it2 = (TransformInput)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            Collection collection3 = transformInput.getDirectoryInputs();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"it.directoryInputs");
            Collection collection4 = it2.getJarInputs();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"it.jarInputs");
            Iterable list$iv$iv = CollectionsKt.plus((Collection)collection3, (Iterable)collection4);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv2 = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $receiver$iv2) {
            TransformInput transformInput = it2 = (QualifiedContent)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"it");
            Set set = transformInput.getScopes();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"it.scopes");
            ImmutableSet immutableSet = libraryScopes;
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"libraryScopes");
            if (!SetsKt.minus((Set)set, (Iterable)((Iterable)immutableSet)).isEmpty()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Object object = new Pair(first$iv, second$iv);
        List list = (List)object.component1();
        List libraries = (List)object.component2();
        object = (Iterable)inputs;
        ProguardInput proguardInput = ProguardInput.INPUT_JAR;
        int n = 0;
        Pair[] pairArray2 = pairArray = new Pair[2];
        $receiver$iv2 = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object element$iv;
            element$iv = (QualifiedContent)item$iv$iv;
            collection = destination$iv$iv2;
            void v7 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
            path = v7.getFile().toPath();
            collection.add(path);
        }
        collection = (List)destination$iv$iv2;
        pairArray[n] = TuplesKt.to((Object)((Object)proguardInput), (Object)collection);
        $receiver$iv = libraries;
        proguardInput = ProguardInput.LIBRARY_JAR;
        n = 1;
        pairArray = pairArray2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (QualifiedContent)item$iv$iv;
            collection = destination$iv$iv2;
            QualifiedContent qualifiedContent = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedContent, (String)"it");
            path = qualifiedContent.getFile().toPath();
            collection.add(path);
        }
        collection = (List)destination$iv$iv2;
        pairArray[n] = TuplesKt.to((Object)((Object)proguardInput), collection);
        return MapsKt.mapOf((Pair[])pairArray2);
    }

    public D8MainDexListTransform(@NotNull BuildableArtifact manifestProguardRules, @Nullable Path userProguardRules, @Nullable Path userClasses, boolean includeDynamicFeatures, @NotNull Supplier<List<Path>> bootClasspath, @NotNull MessageReceiver messageReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)manifestProguardRules, (String)"manifestProguardRules");
        Intrinsics.checkParameterIsNotNull(bootClasspath, (String)"bootClasspath");
        Intrinsics.checkParameterIsNotNull((Object)messageReceiver, (String)"messageReceiver");
        this.manifestProguardRules = manifestProguardRules;
        this.userProguardRules = userProguardRules;
        this.userClasses = userClasses;
        this.includeDynamicFeatures = includeDynamicFeatures;
        this.bootClasspath = bootClasspath;
        this.messageReceiver = messageReceiver;
        this.logger = LoggerWrapper.getLogger(D8MainDexListTransform.class);
    }

    public /* synthetic */ D8MainDexListTransform(BuildableArtifact buildableArtifact, Path path, Path path2, boolean bl, Supplier supplier, MessageReceiver messageReceiver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = null;
        }
        if ((n & 4) != 0) {
            path2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(buildableArtifact, path, path2, bl, supplier, messageReceiver);
    }

    @JvmOverloads
    public D8MainDexListTransform(final @NotNull VariantScope variantScope, boolean includeDynamicFeatures) {
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        BuildableArtifact buildableArtifact = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES);
        GradleVariantConfiguration gradleVariantConfiguration = variantScope.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
        File file = gradleVariantConfiguration.getMultiDexKeepProguard();
        Path path = file != null ? file.toPath() : null;
        GradleVariantConfiguration gradleVariantConfiguration2 = variantScope.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"variantScope.variantConfiguration");
        File file2 = gradleVariantConfiguration2.getMultiDexKeepFile();
        Path path2 = file2 != null ? file2.toPath() : null;
        Supplier supplier = new Supplier<List<? extends Path>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public final List<Path> get() {
                void var3_3;
                void $receiver$iv$iv;
                GlobalScope globalScope = variantScope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope\n           \u2026             .globalScope");
                List list = globalScope.getAndroidBuilder().getBootClasspath(true);
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"variantScope\n           \u2026  .getBootClasspath(true)");
                Iterable $receiver$iv = list;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    Path path = it.toPath();
                    collection.add(path);
                }
                return (List)var3_3;
            }
        };
        GlobalScope globalScope = variantScope.getGlobalScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
        MessageReceiver messageReceiver = globalScope.getMessageReceiver();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageReceiver, (String)"variantScope.globalScope.messageReceiver");
        this(buildableArtifact, path, path2, includeDynamicFeatures, supplier, messageReceiver);
    }

    @JvmOverloads
    public /* synthetic */ D8MainDexListTransform(VariantScope variantScope, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(variantScope, bl);
    }

    @JvmOverloads
    public D8MainDexListTransform(@NotNull VariantScope variantScope) {
        this(variantScope, false, 2, null);
    }
}

