/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiConsumer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;

@CacheableTask
public class AppPreBuildTask
extends AndroidVariantTask {
    private ArtifactCollection compileManifests;
    private ArtifactCollection compileNonNamespacedManifests;
    private ArtifactCollection runtimeManifests;
    private ArtifactCollection runtimeNonNamespacedManifests;
    private File fakeOutputDirectory;
    private boolean isBaseModule;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileCollection getCompileManifests() {
        return this.compileManifests.getArtifactFiles();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileCollection getCompileNonNamespacedManifests() {
        return this.compileNonNamespacedManifests.getArtifactFiles();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileCollection getRuntimeManifests() {
        return this.runtimeManifests.getArtifactFiles();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileCollection getRuntimeNonNamespacedManifests() {
        return this.runtimeNonNamespacedManifests.getArtifactFiles();
    }

    @OutputDirectory
    public File getFakeOutputDirectory() {
        return this.fakeOutputDirectory;
    }

    @Input
    public boolean isBaseModule() {
        return this.isBaseModule;
    }

    @TaskAction
    void run() {
        HashSet compileArtifacts = new HashSet();
        compileArtifacts.addAll(this.compileManifests.getArtifacts());
        compileArtifacts.addAll(this.compileNonNamespacedManifests.getArtifacts());
        HashSet runtimeArtifacts = new HashSet();
        runtimeArtifacts.addAll(this.runtimeManifests.getArtifacts());
        runtimeArtifacts.addAll(this.runtimeNonNamespacedManifests.getArtifacts());
        HashMap runtimeIds = Maps.newHashMapWithExpectedSize((int)runtimeArtifacts.size());
        for (ResolvedArtifactResult artifact : runtimeArtifacts) {
            this.handleArtifact(artifact.getId().getComponentIdentifier(), runtimeIds::put);
        }
        for (ResolvedArtifactResult artifact : compileArtifacts) {
            ComponentIdentifier compileId = artifact.getId().getComponentIdentifier();
            this.handleArtifact(compileId, (key, value) -> {
                String runtimeVersion = (String)runtimeIds.get(key);
                if (runtimeVersion == null) {
                    if (this.isBaseModule) {
                        String display = compileId.getDisplayName();
                        throw new RuntimeException("Android dependency '" + display + "' is set to compileOnly/provided which is not supported");
                    }
                } else if (!runtimeVersion.isEmpty() && !runtimeVersion.equals(value)) {
                    throw new RuntimeException(String.format("Android dependency '%s' has different version for the compile (%s) and runtime (%s) classpath. You should manually set the same version via DependencyResolution", key, value, runtimeVersion));
                }
            });
        }
    }

    private void handleArtifact(ComponentIdentifier id, BiConsumer<String, String> consumer) {
        if (id instanceof ProjectComponentIdentifier) {
            consumer.accept(((ProjectComponentIdentifier)id).getProjectPath().intern(), "");
        } else if (id instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)id;
            consumer.accept(moduleComponentId.getGroup() + ":" + moduleComponentId.getModule(), moduleComponentId.getVersion());
        } else if (!(id instanceof OpaqueComponentArtifactIdentifier)) {
            this.getLogger().warn("Unknown ComponentIdentifier type: " + id.getClass().getCanonicalName());
        }
    }

    public static class CreationAction
    extends TaskManager.AbstractPreBuildCreationAction<AppPreBuildTask> {
        public CreationAction(VariantScope variantScope) {
            super(variantScope);
        }

        @Override
        public Class<AppPreBuildTask> getType() {
            return AppPreBuildTask.class;
        }

        @Override
        public void configure(AppPreBuildTask task) {
            super.configure(task);
            task.setVariantName(this.variantScope.getFullVariantName());
            task.isBaseModule = this.variantScope.getType().isBaseModule();
            task.compileManifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            task.compileNonNamespacedManifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.NON_NAMESPACED_MANIFEST);
            task.runtimeManifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            task.runtimeNonNamespacedManifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.NON_NAMESPACED_MANIFEST);
            task.fakeOutputDirectory = new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "prebuild/" + this.variantScope.getVariantConfiguration().getDirName());
        }
    }
}

