/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.BuildSessionImpl;
import com.android.builder.model.Version;
import com.android.utils.JvmWideVariable;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Project;

@ThreadSafe
public final class PluginInitializer {
    private static final ConcurrentMap<Object, String> projectToPluginVersionMap = (ConcurrentMap)Verify.verifyNotNull((Object)new JvmWideVariable("PLUGIN_VERSION_CHECK", "PROJECT_TO_PLUGIN_VERSION", (TypeToken)new TypeToken<ConcurrentMap<Object, String>>(){}, ConcurrentHashMap::new).get());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Project project) {
        BuildSessionImpl.getSingleton().initialize(project.getGradle());
        BuildSessionImpl.getSingleton().executeOnceWhenBuildFinished(PluginInitializer.class.getName(), "resetPluginVersionCheckVariable", projectToPluginVersionMap::clear);
        ConcurrentMap<Object, String> concurrentMap = projectToPluginVersionMap;
        synchronized (concurrentMap) {
            PluginInitializer.verifySamePluginVersion(projectToPluginVersionMap, project, Version.ANDROID_GRADLE_PLUGIN_VERSION);
        }
    }

    static void verifySamePluginVersion(ConcurrentMap<Object, String> projectToPluginVersionMap, Project project, String pluginVersion) {
        Preconditions.checkState((!projectToPluginVersionMap.containsKey(project) ? 1 : 0) != 0, (Object)String.format("Android Gradle plugin %1$s must not be applied to project '%2$s' since version %3$s was already applied to this project", pluginVersion, project.getProjectDir().getAbsolutePath(), projectToPluginVersionMap.get(project)));
        projectToPluginVersionMap.put(project, pluginVersion);
        if (projectToPluginVersionMap.values().stream().distinct().count() > 1L) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Using multiple versions of the Android Gradle plugin in the same build is not allowed.");
            for (Map.Entry entry : projectToPluginVersionMap.entrySet()) {
                Preconditions.checkState((boolean)(entry.getKey() instanceof Project), (Object)(Project.class + " should be loaded only once"));
                Project fromProject = (Project)entry.getKey();
                String toPluginVersion = (String)entry.getValue();
                errorMessage.append(String.format("\n\t'%1$s' is using version %2$s", fromProject.getProjectDir().getAbsolutePath(), toPluginVersion));
            }
            throw new IllegalStateException(errorMessage.toString());
        }
    }
}

