/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.packaging.JarMerger;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0014H\u0007R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR&\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/tasks/ZipMergingTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "javaResInputFiles", "getJavaResInputFiles", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setJavaResInputFiles", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "libraryInputFiles", "getLibraryInputFiles", "setLibraryInputFiles", "Ljava/io/File;", "outputFile", "getOutputFile", "()Ljava/io/File;", "setOutputFile", "(Ljava/io/File;)V", "init", "", "init$gradle", "merge", "CreationAction", "gradle"})
public class ZipMergingTask
extends AndroidVariantTask {
    @NotNull
    private BuildableArtifact libraryInputFiles;
    @NotNull
    private BuildableArtifact javaResInputFiles;
    @NotNull
    private File outputFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getLibraryInputFiles() {
        BuildableArtifact buildableArtifact = this.libraryInputFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"libraryInputFiles");
        }
        return buildableArtifact;
    }

    private final void setLibraryInputFiles(BuildableArtifact buildableArtifact) {
        this.libraryInputFiles = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getJavaResInputFiles() {
        BuildableArtifact buildableArtifact = this.javaResInputFiles;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaResInputFiles");
        }
        return buildableArtifact;
    }

    private final void setJavaResInputFiles(BuildableArtifact buildableArtifact) {
        this.javaResInputFiles = buildableArtifact;
    }

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    private final void setOutputFile(File file) {
        this.outputFile = file;
    }

    public final void init$gradle(@NotNull BuildableArtifact libraryInputFiles, @NotNull BuildableArtifact javaResInputFiles, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)libraryInputFiles, (String)"libraryInputFiles");
        Intrinsics.checkParameterIsNotNull((Object)javaResInputFiles, (String)"javaResInputFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        this.libraryInputFiles = libraryInputFiles;
        this.javaResInputFiles = javaResInputFiles;
        this.outputFile = outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void merge() throws IOException {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        FileUtils.cleanOutputDir((File)file.getParentFile());
        Predicate<String> usedNamesPredicate2 = new Predicate<String>(){
            @NotNull
            private final Set<String> usedNames;

            @NotNull
            public final Set<String> getUsedNames() {
                return this.usedNames;
            }

            public boolean test(@NotNull String t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                return this.usedNames.add(t);
            }
            {
                Set set;
                merge.usedNamesPredicate.1 var1_1 = this;
                var1_1.usedNames = set = (Set)new LinkedHashSet<E>();
            }
        };
        File file2 = this.outputFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        Closeable closeable = (Closeable)new JarMerger(file2.toPath(), (Predicate)usedNamesPredicate2);
        Throwable throwable = null;
        try {
            File jar;
            JarMerger it = (JarMerger)closeable;
            BuildableArtifact buildableArtifact = this.libraryInputFiles;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"libraryInputFiles");
            }
            Iterable $receiver$iv = buildableArtifact.getFiles();
            for (Object element$iv : $receiver$iv) {
                jar = (File)element$iv;
                it.addJar(jar.toPath());
            }
            BuildableArtifact buildableArtifact2 = this.javaResInputFiles;
            if (buildableArtifact2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"javaResInputFiles");
            }
            $receiver$iv = buildableArtifact2.getFiles();
            for (Object element$iv : $receiver$iv) {
                jar = (File)element$iv;
                it.addJar(jar.toPath());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/tasks/ZipMergingTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/tasks/ZipMergingTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "mainFullJar", "Ljava/io/File;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ZipMergingTask> {
        private File mainFullJar;

        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("createFullJar");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"createFullJar\")");
            return string;
        }

        @Override
        @NotNull
        public Class<ZipMergingTask> getType() {
            return ZipMergingTask.class;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            super.preConfigure(taskName);
            this.mainFullJar = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.FULL_JAR, taskName, "full.jar");
        }

        @Override
        public void configure(@NotNull ZipMergingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            BuildArtifactsHolder buildArtifactsHolder = this.getVariantScope().getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildArtifactsHolder, (String)"variantScope.artifacts");
            BuildArtifactsHolder buildArtifacts = buildArtifactsHolder;
            BuildableArtifact buildableArtifact = buildArtifacts.getOptionalFinalArtifactFiles(InternalArtifactType.LIBRARY_CLASSES);
            BuildableArtifact buildableArtifact2 = buildArtifacts.getOptionalFinalArtifactFiles(InternalArtifactType.LIBRARY_JAVA_RES);
            File file = this.mainFullJar;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mainFullJar");
            }
            task.init$gradle(buildableArtifact, buildableArtifact2, file);
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

