/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

abstract class ClasspathComparisionTask
extends AndroidVariantTask {
    protected ArtifactCollection runtimeClasspath;
    protected ArtifactCollection compileClasspath;
    protected File fakeOutputDirectory;

    ClasspathComparisionTask() {
    }

    @CompileClasspath
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getRuntimeClasspath() {
        return this.runtimeClasspath.getArtifactFiles();
    }

    @CompileClasspath
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getCompileClasspath() {
        return this.compileClasspath.getArtifactFiles();
    }

    @OutputDirectory
    public File getFakeOutputDirectory() {
        return this.fakeOutputDirectory;
    }

    abstract void onDifferentVersionsFound(String var1, String var2, String var3, String var4);

    void compareClasspaths() {
        Map subMap;
        ModuleComponentIdentifier moduleId;
        ComponentIdentifier componentIdentifier;
        Set runtimeArtifacts = this.runtimeClasspath.getArtifacts();
        Set compileArtifacts = this.compileClasspath.getArtifacts();
        HashMap runtimeIds = Maps.newHashMapWithExpectedSize((int)runtimeArtifacts.size());
        for (ResolvedArtifactResult artifact : runtimeArtifacts) {
            componentIdentifier = artifact.getId().getComponentIdentifier();
            if (!(componentIdentifier instanceof ModuleComponentIdentifier)) continue;
            moduleId = (ModuleComponentIdentifier)componentIdentifier;
            subMap = runtimeIds.computeIfAbsent(moduleId.getGroup(), s -> new HashMap());
            subMap.put(moduleId.getModule(), moduleId.getVersion());
        }
        for (ResolvedArtifactResult artifact : compileArtifacts) {
            String runtimeVersion;
            componentIdentifier = artifact.getId().getComponentIdentifier();
            if (!(componentIdentifier instanceof ModuleComponentIdentifier) || (subMap = (Map)runtimeIds.get((moduleId = (ModuleComponentIdentifier)componentIdentifier).getGroup())) == null || (runtimeVersion = (String)subMap.get(moduleId.getModule())) == null || runtimeVersion.equals(moduleId.getVersion())) continue;
            this.onDifferentVersionsFound(moduleId.getGroup(), moduleId.getModule(), runtimeVersion, moduleId.getVersion());
        }
    }
}

