/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.SigningConfig;
import com.android.ide.common.build.ApkInfo;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kotlin.jvm.functions.Function2;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

public class PackageSplitAbi
extends AndroidBuilderTask {
    private BuildableArtifact processedAbiResources;
    private File outputDirectory;
    private boolean jniDebuggable;
    private SigningConfig signingConfig;
    private FileCollection jniFolders;
    private AndroidVersion minSdkVersion;
    private File incrementalDir;
    private Collection<String> aaptOptionsNoCompress;
    private Set<String> splits;

    @InputFiles
    public BuildableArtifact getProcessedAbiResources() {
        return this.processedAbiResources;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    @Input
    public boolean isJniDebuggable() {
        return this.jniDebuggable;
    }

    @Nested
    @Optional
    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    @InputFiles
    public FileCollection getJniFolders() {
        return this.jniFolders;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getFeatureLevel();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return this.aaptOptionsNoCompress != null ? this.aaptOptionsNoCompress : Collections.emptyList();
    }

    @TaskAction
    protected void doFullTaskAction() throws IOException {
        FileUtils.cleanOutputDir((File)this.incrementalDir);
        ExistingBuildElements.from((ArtifactType)InternalArtifactType.ABI_PROCESSED_SPLIT_RES, this.processedAbiResources).transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(split, output2) -> {
            String apkName = this.getApkName((ApkInfo)split);
            File outFile = new File(this.outputDirectory, apkName);
            try (IncrementalPackager pkg = new IncrementalPackagerBuilder().withOutputFile(outFile).withSigning(this.signingConfig).withCreatedBy(this.getBuilder().getCreatedBy()).withMinSdk(this.getMinSdkVersion()).withAaptOptionsNoCompress(this.aaptOptionsNoCompress).withIntermediateDir(this.incrementalDir).withProject(this.getProject()).withDebuggableBuild(this.isJniDebuggable()).withJniDebuggableBuild(this.isJniDebuggable()).withAcceptedAbis((Set<String>)ImmutableSet.of((Object)split.getFilterName())).withIssueReporter(this.getBuilder().getIssueReporter()).build();){
                ImmutableMap nativeLibs = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJniFolders());
                pkg.updateNativeLibraries(nativeLibs);
                ImmutableMap androidResources = IncrementalRelativeFileSets.fromZip((File)output2);
                pkg.updateAndroidResources(androidResources);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            return outFile;
        })).into(InternalArtifactType.ABI_PACKAGED_SPLIT, this.outputDirectory);
    }

    private String getApkName(ApkInfo apkData) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        String apkName = archivesBaseName + "-" + apkData.getBaseName();
        return apkName + (this.getSigningConfig() == null ? "-unsigned" : "") + ".apk";
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageSplitAbi> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "SplitAbi");
        }

        @Override
        public Class<PackageSplitAbi> getType() {
            return PackageSplitAbi.class;
        }

        @Override
        public void execute(PackageSplitAbi packageSplitAbiTask) {
            GradleVariantConfiguration config2 = this.scope.getVariantConfiguration();
            packageSplitAbiTask.processedAbiResources = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.ABI_PROCESSED_SPLIT_RES);
            packageSplitAbiTask.signingConfig = ((VariantConfiguration)config2).getSigningConfig();
            packageSplitAbiTask.outputDirectory = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.ABI_PACKAGED_SPLIT, (Task)packageSplitAbiTask, "out");
            packageSplitAbiTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            packageSplitAbiTask.setVariantName(config2.getFullName());
            packageSplitAbiTask.minSdkVersion = config2.getMinSdkVersion();
            packageSplitAbiTask.incrementalDir = this.scope.getIncrementalDir(packageSplitAbiTask.getName());
            packageSplitAbiTask.aaptOptionsNoCompress = this.scope.getGlobalScope().getExtension().getAaptOptions().getNoCompress();
            packageSplitAbiTask.jniDebuggable = config2.getBuildType().isJniDebuggable();
            packageSplitAbiTask.jniFolders = this.scope.getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.NATIVE_LIBS);
            packageSplitAbiTask.jniDebuggable = config2.getBuildType().isJniDebuggable();
            packageSplitAbiTask.splits = this.scope.getVariantData().getFilters(VariantOutput.FilterType.ABI);
        }
    }
}

