/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.builder.dexing.DexSplitterTool;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\b\u0010\u000f\u001a\u00020\rH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\nH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/transforms/DexSplitterTransform;", "Lcom/android/build/api/transform/Transform;", "outputDir", "Ljava/io/File;", "featureJars", "Lorg/gradle/api/file/FileCollection;", "mappingFileSrc", "Lcom/android/build/api/artifact/BuildableArtifact;", "(Ljava/io/File;Lorg/gradle/api/file/FileCollection;Lcom/android/build/api/artifact/BuildableArtifact;)V", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getModulePath", "", "jarFile", "getName", "getOutputTypes", "getScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getSecondaryDirectoryOutputs", "", "getSecondaryFiles", "Lcom/android/build/api/transform/SecondaryFile;", "isIncremental", "", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle"})
public final class DexSplitterTransform
extends Transform {
    private final File outputDir;
    private final FileCollection featureJars;
    private final BuildableArtifact mappingFileSrc;

    @NotNull
    public String getName() {
        return "dexSplitter";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_DEX;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"CONTENT_DEX");
        return set;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getOutputTypes() {
        Set<QualifiedContent.ContentType> set = TransformManager.CONTENT_DEX;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"CONTENT_DEX");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set<QualifiedContent.ScopeType> set = TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES");
        return set;
    }

    public boolean isIncremental() {
        return false;
    }

    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        Collection secondaryFiles;
        block0: {
            BuildableArtifact buildableArtifact;
            secondaryFiles = new ArrayList();
            SecondaryFile secondaryFile = SecondaryFile.nonIncremental((FileCollection)this.featureJars);
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile, (String)"SecondaryFile.nonIncremental(featureJars)");
            secondaryFiles.add(secondaryFile);
            BuildableArtifact buildableArtifact2 = this.mappingFileSrc;
            if (buildableArtifact2 == null) break block0;
            BuildableArtifact it = buildableArtifact = buildableArtifact2;
            SecondaryFile secondaryFile2 = SecondaryFile.nonIncremental((Supplier)((Supplier)it));
            Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile2, (String)"SecondaryFile.nonIncremental(it)");
            secondaryFiles.add(secondaryFile2);
        }
        return secondaryFiles;
    }

    @NotNull
    public Collection<File> getSecondaryDirectoryOutputs() {
        return CollectionsKt.mutableListOf((Object[])new File[]{this.outputDir});
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        try {
            Object object;
            File transformOutputDir;
            Object object2;
            block8: {
                Object object3 = this.mappingFileSrc;
                File mappingFile = object3 != null && (object3 = BuildableArtifactUtil.singleFile((BuildableArtifact)object3)) != null && ((File)object3).exists() && !BuildableArtifactUtil.singleFile(this.mappingFileSrc).isDirectory() ? BuildableArtifactUtil.singleFile(this.mappingFileSrc) : null;
                TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
                if (transformOutputProvider == null) {
                    String string = "No output provider set";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                TransformOutputProvider outputProvider = transformOutputProvider;
                outputProvider.deleteAll();
                FileUtils.deleteRecursivelyIfExists((File)this.outputDir);
                Path path = this.outputDir.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputDir.toPath()");
                File file = mappingFile;
                DexSplitterTool.Builder builder = new DexSplitterTool.Builder(path, file != null ? file.toPath() : null);
                for (File dirInput : TransformInputUtil.getDirectories(transformInvocation.getInputs())) {
                    Iterator $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Object object4 = dirInput.listFiles();
                    if (object4 == null || (object4 = ArraysKt.toList((Object[])object4)) == null) continue;
                    Iterable iterable = $receiver$iv = (Iterable)object4;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    Object object5 = $receiver$iv$iv.iterator();
                    while (object5.hasNext()) {
                        void it;
                        Object item$iv$iv = object5.next();
                        File file2 = (File)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Path path2 = it.toPath();
                        collection.add(path2);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        Path it;
                        Object element$iv = $receiver$iv$iv.next();
                        Path path3 = it = (Path)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"it");
                        builder.addInputArchive(path3);
                    }
                }
                Set set = this.featureJars.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureJars.files");
                Iterable $receiver$iv = set;
                object2 = $receiver$iv.iterator();
                while (object2.hasNext()) {
                    File element$iv = object2.next();
                    File file3 = element$iv;
                    StringBuilder stringBuilder = new StringBuilder().append("features");
                    File file4 = file3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file");
                    String modulePath = stringBuilder.append(StringsKt.replace$default((String)this.getModulePath(file4), (String)":", (String)"/", (boolean)false, (int)4, null)).toString();
                    Path path4 = file3.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"file.toPath()");
                    builder.addFeatureJar(path4, modulePath);
                    Files.createDirectories(new File(this.outputDir, modulePath).toPath(), new FileAttribute[0]);
                }
                builder.build().run();
                transformOutputDir = outputProvider.getContentLocation("splitDexFiles", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                Files.createDirectories(transformOutputDir.toPath(), new FileAttribute[0]);
                File[] fileArray = this.outputDir.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"outputDir.listFiles()");
                for (Object object5 : object2 = (Object[])fileArray) {
                    File it;
                    File file5 = it = (File)object5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"it");
                    if (!Intrinsics.areEqual((Object)file5.getName(), (Object)"base")) continue;
                    object = object5;
                    break block8;
                }
                object = null;
            }
            File file = (File)object;
            if (file == null) return;
            Object it = object2 = file;
            FileUtils.copyDirectory((File)it, (File)transformOutputDir);
            FileUtils.deleteRecursivelyIfExists((File)it);
            return;
        }
        catch (Exception e) {
            throw (Throwable)new TransformException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getModulePath(File jarFile) {
        String string;
        Closeable closeable = new JarFile(jarFile);
        Throwable throwable = null;
        try {
            JarFile it = (JarFile)closeable;
            Manifest manifest = it.getManifest();
            Intrinsics.checkExpressionValueIsNotNull((Object)manifest, (String)"it.manifest");
            String string2 = manifest.getMainAttributes().getValue("module-path");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.manifest.mainAttributes.getValue(MODULE_PATH)");
            String string3 = string2;
            string = string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JarFile(jarFile).use { i\u2026s.getValue(MODULE_PATH) }");
        return string;
    }

    public DexSplitterTransform(@NotNull File outputDir, @NotNull FileCollection featureJars, @Nullable BuildableArtifact mappingFileSrc) {
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull((Object)featureJars, (String)"featureJars");
        this.outputDir = outputDir;
        this.featureJars = featureJars;
        this.mappingFileSrc = mappingFileSrc;
    }
}

