/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.ModuleInfo;
import com.android.build.gradle.internal.tasks.ModuleInfoAdapter;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\b\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"loadModule", "Lcom/android/build/gradle/internal/tasks/ModuleInfo;", "from", "Ljava/io/File;", "saveModules", "", "modules", "", "to", "gradle"})
public final class ModuleInfoKt {
    public static final void saveModules(@NotNull List<ModuleInfo> modules, @NotNull File to) {
        Intrinsics.checkParameterIsNotNull(modules, (String)"modules");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ModuleInfo.class), (Object)new ModuleInfoAdapter()).create();
        FileUtils.mkdirs((File)to.getParentFile());
        Files.asCharSink((File)to, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)gson.toJson(modules));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ModuleInfo loadModule(@NotNull File from) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        try {
            Closeable closeable = new FileReader(from);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter((Type)((Object)ModuleInfo.class), (Object)new ModuleInfoAdapter());
                Gson gson = gsonBuilder.create();
                Type recordType2 = new TypeToken<ModuleInfo>(){}.getType();
                Object object = gson.fromJson((Reader)reader, recordType2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson<ModuleInfo>(reader, recordType)");
                ModuleInfo moduleInfo = (ModuleInfo)object;
                return moduleInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }
}

