/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zip.CentralDirectoryHeader;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J8\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/FolderBasedApkCreator;", "Lcom/android/tools/build/apkzlib/zfile/ApkCreator;", "creationData", "Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;", "(Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;)V", "close", "", "deleteFile", "entryPath", "", "hasPendingChangesWithWait", "", "writeFile", "inputFile", "Ljava/io/File;", "writeZip", "zip", "transform", "Ljava/util/function/Function;", "isIgnored", "Ljava/util/function/Predicate;", "gradle"})
public final class FolderBasedApkCreator
implements ApkCreator {
    private final ApkCreatorFactory.CreationData creationData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZip(@Nullable File zip, @Nullable Function<String, String> transform2, @Nullable Predicate<String> isIgnored) {
        if (zip == null) {
            return;
        }
        Closeable closeable = (Closeable)new ZFile(zip);
        Throwable throwable = null;
        try {
            ZFile it = (ZFile)closeable;
            Set set = it.entries();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"it.entries()");
            Iterable $receiver$iv = set;
            for (Object element$iv : $receiver$iv) {
                FolderBasedApkCreator folderBasedApkCreator;
                StoredEntry entry = (StoredEntry)element$iv;
                FolderBasedApkCreator $receiver = folderBasedApkCreator = this;
                Predicate<String> predicate = isIgnored;
                if (predicate != null) {
                    StoredEntry storedEntry = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)storedEntry, (String)"entry");
                    CentralDirectoryHeader centralDirectoryHeader = storedEntry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader, (String)"entry.centralDirectoryHeader");
                    if (predicate.test(centralDirectoryHeader.getName())) continue;
                }
                Closeable closeable2 = entry.open();
                Throwable throwable2 = null;
                try {
                    InputStream it2 = (InputStream)closeable2;
                    File file = $receiver.creationData.getApkPath();
                    StoredEntry storedEntry = entry;
                    Intrinsics.checkExpressionValueIsNotNull((Object)storedEntry, (String)"entry");
                    CentralDirectoryHeader centralDirectoryHeader = storedEntry.getCentralDirectoryHeader();
                    Intrinsics.checkExpressionValueIsNotNull((Object)centralDirectoryHeader, (String)"entry.centralDirectoryHeader");
                    File destinationFile = new File(file, centralDirectoryHeader.getName());
                    destinationFile.getParentFile().mkdirs();
                    long l = Files.copy(it2, destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void writeFile(@Nullable File inputFile, @Nullable String entryPath) {
        if (inputFile == null) {
            return;
        }
        File destinationFile = new File(this.creationData.getApkPath(), entryPath);
        destinationFile.getParentFile().mkdirs();
        Files.copy(inputFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void deleteFile(@Nullable String entryPath) {
        Files.deleteIfExists(new File(this.creationData.getApkPath(), entryPath).toPath());
    }

    public boolean hasPendingChangesWithWait() {
        return false;
    }

    public void close() {
    }

    public FolderBasedApkCreator(@NotNull ApkCreatorFactory.CreationData creationData) {
        Intrinsics.checkParameterIsNotNull((Object)creationData, (String)"creationData");
        this.creationData = creationData;
        File apkPath = this.creationData.getApkPath();
        if (!apkPath.exists()) {
            apkPath.mkdirs();
        }
        File file = apkPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"apkPath");
        boolean bl = file.isDirectory();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

