/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunAnalyticsHelper;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.builder.profile.ProcessProfileWriter;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskAction;

public class BuildInfoWriterTask
extends AndroidVariantTask {
    File buildInfoFile;
    File tmpBuildInfoFile;
    Logger logger;
    InstantRunBuildContext buildContext;

    @TaskAction
    public void executeAction() {
        if (this.buildContext.getBuildHasFailed()) {
            try {
                this.buildContext.writeTmpBuildInfo(this.tmpBuildInfoFile);
            }
            catch (IOException | ParserConfigurationException e) {
                throw new RuntimeException("Exception while saving temp-build-info.xml", e);
            }
            return;
        }
        this.buildContext.close();
        try {
            String xml = this.buildContext.toXml();
            if (this.logger.isEnabled(LogLevel.DEBUG)) {
                this.logger.debug("build-id $1$l, build-info.xml : %2$s", (Object)this.buildContext.getBuildId(), (Object)xml);
            }
            Files.createParentDirs((File)this.buildInfoFile);
            Files.write((CharSequence)xml, (File)this.buildInfoFile, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while saving build-info.xml", e);
        }
        ProcessProfileWriter.getGlobalProperties().setInstantRunStatus(InstantRunAnalyticsHelper.generateAnalyticsProto(this.buildContext));
    }

    public static class ConfigAction
    implements TaskConfigAction<BuildInfoWriterTask> {
        private final String taskName;
        private final InstantRunVariantScope variantScope;
        private final Logger logger;

        public static File getBuildInfoFile(InstantRunVariantScope scope) {
            return new File(scope.getBuildInfoOutputFolder(), "build-info.xml");
        }

        public static File getTmpBuildInfoFile(InstantRunVariantScope scope) {
            return new File(scope.getBuildInfoOutputFolder(), "tmp-build-info.xml");
        }

        public ConfigAction(InstantRunVariantScope scope, Logger logger) {
            this.taskName = scope.getTransformVariantScope().getTaskName("buildInfoGenerator");
            this.variantScope = scope;
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<BuildInfoWriterTask> getType() {
            return BuildInfoWriterTask.class;
        }

        @Override
        public void execute(BuildInfoWriterTask task) {
            task.setDescription("InstantRun task to build incremental artifacts");
            task.setVariantName(this.variantScope.getFullVariantName());
            task.buildInfoFile = ConfigAction.getBuildInfoFile(this.variantScope);
            task.tmpBuildInfoFile = ConfigAction.getTmpBuildInfoFile(this.variantScope);
            task.buildContext = this.variantScope.getInstantRunBuildContext();
            task.logger = this.logger;
        }
    }
}

