/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api;

import com.android.build.api.AndroidPluginVersion;
import java.util.Comparator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Incubating;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002 !B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\u0011\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0000H\u0007J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003J\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/android/build/api/AndroidPluginVersion;", "", "major", "", "minor", "(II)V", "micro", "(III)V", "_previewType", "Lcom/android/build/api/AndroidPluginVersion$PreviewType;", "preview", "(IIILcom/android/build/api/AndroidPluginVersion$PreviewType;I)V", "getMajor", "()I", "getMicro", "getMinor", "getPreview", "previewType", "", "getPreviewType", "()Ljava/lang/String;", "alpha", "beta", "compareTo", "other", "dev", "equals", "", "", "hashCode", "rc", "toString", "Companion", "PreviewType", "gradle-api"})
public final class AndroidPluginVersion
implements Comparable<AndroidPluginVersion> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int micro;
    @NotNull
    private final PreviewType _previewType;
    private final int preview;
    @Deprecated
    @NotNull
    private static final Comparator<AndroidPluginVersion> comparator;

    private AndroidPluginVersion(int major, int minor, int micro, PreviewType _previewType, int preview) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this._previewType = _previewType;
        this.preview = preview;
        boolean bl = this.major >= 0 && this.minor >= 0 && this.micro >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Versions of the Android Gradle Plugin must not be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMicro() {
        return this.micro;
    }

    public final int getPreview() {
        return this.preview;
    }

    @Nullable
    public final String getPreviewType() {
        return this._previewType.getPublicName();
    }

    public AndroidPluginVersion(int major, int minor) {
        this(major, minor, 0, PreviewType.FINAL, 0);
    }

    public AndroidPluginVersion(int major, int minor, int micro) {
        this(major, minor, micro, PreviewType.FINAL, 0);
    }

    @NotNull
    public final AndroidPluginVersion alpha(int alpha) {
        boolean bl = this._previewType == PreviewType.FINAL;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "alpha(int) only expected to be called on final versions";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = alpha >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Alpha version must be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new AndroidPluginVersion(this.major, this.minor, this.micro, PreviewType.ALPHA, alpha);
    }

    @NotNull
    public final AndroidPluginVersion beta(int beta) {
        boolean bl = this._previewType == PreviewType.FINAL;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "beta(int) only expected to be called on final versions";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = beta >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Beta version must be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new AndroidPluginVersion(this.major, this.minor, this.micro, PreviewType.BETA, beta);
    }

    @NotNull
    public final AndroidPluginVersion rc(int rc) {
        boolean bl = this._previewType == PreviewType.FINAL;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "rc(int) only expected to be called on final versions";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = rc >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Release candidate version must be at least 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new AndroidPluginVersion(this.major, this.minor, this.micro, PreviewType.RC, rc);
    }

    @Incubating
    @NotNull
    public final AndroidPluginVersion dev() {
        return new AndroidPluginVersion(this.major, this.minor, this.micro, PreviewType.DEV, 0);
    }

    @Override
    public int compareTo(@NotNull AndroidPluginVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return comparator.compare(this, other);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AndroidPluginVersion && this.major == ((AndroidPluginVersion)other).major && this.minor == ((AndroidPluginVersion)other).minor && this.micro == ((AndroidPluginVersion)other).micro && this._previewType == ((AndroidPluginVersion)other)._previewType && this.preview == ((AndroidPluginVersion)other).preview;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.major, this.minor, this.micro, this._previewType, this.preview};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "Android Gradle Plugin version " + this.major + '.' + this.minor + '.' + this.micro + (this.getPreviewType() != null ? Intrinsics.stringPlus((String)"-", (Object)this.getPreviewType()) : "") + (this.preview > 0 ? Integer.valueOf(this.preview) : "");
    }

    public static final /* synthetic */ PreviewType access$get_previewType$p(AndroidPluginVersion $this) {
        return $this._previewType;
    }

    static {
        Comparator comparator2 = Comparator.comparingInt(Companion.comparator.1.INSTANCE).thenComparingInt(Companion.comparator.2.INSTANCE).thenComparingInt(Companion.comparator.3.INSTANCE).thenComparingInt(Companion.comparator.4.INSTANCE).thenComparingInt(Companion.comparator.5.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparingInt<AndroidPlug\u2026mparingInt { it.preview }");
        comparator = comparator2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/build/api/AndroidPluginVersion$PreviewType;", "", "publicName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPublicName", "()Ljava/lang/String;", "ALPHA", "BETA", "RC", "DEV", "FINAL", "gradle-api"})
    private static final class PreviewType
    extends Enum<PreviewType> {
        @Nullable
        private final String publicName;
        public static final /* enum */ PreviewType ALPHA = new PreviewType("alpha");
        public static final /* enum */ PreviewType BETA = new PreviewType("beta");
        public static final /* enum */ PreviewType RC = new PreviewType("rc");
        public static final /* enum */ PreviewType DEV = new PreviewType("dev");
        public static final /* enum */ PreviewType FINAL = new PreviewType(null);
        private static final /* synthetic */ PreviewType[] $VALUES;

        private PreviewType(String publicName) {
            this.publicName = publicName;
        }

        @Nullable
        public final String getPublicName() {
            return this.publicName;
        }

        public static PreviewType[] values() {
            return (PreviewType[])$VALUES.clone();
        }

        public static PreviewType valueOf(String value) {
            return Enum.valueOf(PreviewType.class, value);
        }

        static {
            $VALUES = previewTypeArray = new PreviewType[]{PreviewType.ALPHA, PreviewType.BETA, PreviewType.RC, PreviewType.DEV, PreviewType.FINAL};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/api/AndroidPluginVersion$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "Lcom/android/build/api/AndroidPluginVersion;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "gradle-api"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<AndroidPluginVersion> getComparator() {
            return comparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

