/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import shadow.bundletool.com.android.zipflinger.BytesSource;

public class FullFileSource
extends BytesSource {
    public FullFileSource(String filePath, String entryName, int compressionLevel) throws IOException {
        this(filePath, entryName, compressionLevel, Symlink.FOLLOW);
    }

    public FullFileSource(String filePath, String entryName, int compressionLevel, Symlink symlinkPolicy) throws IOException {
        super(entryName);
        byte[] bytes;
        Path path = Paths.get(filePath, new String[0]);
        if (Files.isExecutable(path)) {
            this.externalAttributes |= 0x490000;
        }
        if (!Files.isSymbolicLink(path) || symlinkPolicy == Symlink.FOLLOW) {
            bytes = Files.readAllBytes(path);
        } else {
            this.externalAttributes |= 0xA0000000;
            compressionLevel = 0;
            Path target = Files.readSymbolicLink(path);
            bytes = target.toString().getBytes(StandardCharsets.US_ASCII);
        }
        this.build(bytes, bytes.length, compressionLevel);
    }

    public static enum Symlink {
        FOLLOW,
        DO_NOT_FOLLOW;

    }
}

