/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.ddmlib.internal.jdwp.interceptor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.JdwpProxyClient;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.ChunkHandler;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import shadow.bundletool.com.android.ddmlib.internal.jdwp.interceptor.Interceptor;

public class NoReplyPacketInterceptor
implements Interceptor {
    private List<ByteBuffer> mCachedPackets = new ArrayList<ByteBuffer>();
    private Set<JdwpProxyClient> mClientsSentCacheTo = new HashSet<JdwpProxyClient>();

    @VisibleForTesting
    List<ByteBuffer> getCachedPackets() {
        return this.mCachedPackets;
    }

    @VisibleForTesting
    Set<JdwpProxyClient> getClientsSentCacheTo() {
        return this.mClientsSentCacheTo;
    }

    @Override
    public boolean filterToClient(JdwpProxyClient to, JdwpPacket packetToSend) throws IOException, TimeoutException {
        if (to.isHandshakeComplete() && !this.mClientsSentCacheTo.contains(to)) {
            this.sendCacheToClient(to);
        }
        if (packetToSend.isEmpty() || packetToSend.isError() || packetToSend.isReply()) {
            return false;
        }
        ByteBuffer buffer = ByteBuffer.allocate(packetToSend.getLength());
        buffer.order(ChunkHandler.CHUNK_ORDER);
        packetToSend.copy(buffer);
        this.mCachedPackets.add(buffer);
        return !to.isHandshakeComplete();
    }

    private void sendCacheToClient(JdwpProxyClient client) throws IOException, TimeoutException {
        for (ByteBuffer packet : this.mCachedPackets) {
            client.write(packet.array(), packet.position());
        }
        this.mClientsSentCacheTo.add(client);
        this.mClientsSentCacheTo.removeIf(c4 -> !c4.isConnected());
    }
}

