/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class CodeTransparencyFactory {
    public static CodeTransparencyOuterClass.CodeTransparency createCodeTransparencyMetadata(AppBundle bundle) {
        CodeTransparencyOuterClass.CodeTransparency.Builder transparencyBuilder = CodeTransparencyOuterClass.CodeTransparency.newBuilder();
        bundle.getFeatureModules().values().forEach(featureModule -> CodeTransparencyFactory.addModuleToTransparencyFile(transparencyBuilder, featureModule));
        return transparencyBuilder.build();
    }

    private static void addModuleToTransparencyFile(CodeTransparencyOuterClass.CodeTransparency.Builder codeTransparencyBuilder, BundleModule module) {
        module.getEntries().stream().filter(CodeTransparencyFactory::isCodeRelatedFile).forEach(moduleEntry -> codeTransparencyBuilder.addCodeRelatedFile(CodeTransparencyFactory.createCodeRelatedFile(moduleEntry)));
    }

    private static CodeTransparencyOuterClass.CodeRelatedFile createCodeRelatedFile(ModuleEntry moduleEntry) {
        CodeTransparencyOuterClass.CodeRelatedFile.Builder codeRelatedFile = CodeTransparencyOuterClass.CodeRelatedFile.newBuilder().setPath(moduleEntry.getBundlePath().get().toString());
        if (moduleEntry.getPath().startsWith(BundleModule.LIB_DIRECTORY)) {
            codeRelatedFile.setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.NATIVE_LIBRARY);
            codeRelatedFile.setApkPath(moduleEntry.getPath().toString());
        } else {
            codeRelatedFile.setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.DEX);
        }
        try {
            codeRelatedFile.setSha256(moduleEntry.getContent().hash(Hashing.sha256()).toString());
        }
        catch (IOException e4) {
            throw new UncheckedIOException("An error occurred when calculating file hash.", e4);
        }
        return codeRelatedFile.build();
    }

    private static boolean isCodeRelatedFile(ModuleEntry moduleEntry) {
        return moduleEntry.getPath().startsWith(BundleModule.DEX_DIRECTORY) || moduleEntry.getPath().startsWith(BundleModule.LIB_DIRECTORY) && moduleEntry.getPath().toString().endsWith(".so");
    }

    private CodeTransparencyFactory() {
    }
}

