/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.ModuleSplit;

public final class CodeTransparencyInjector {
    private final BundleMetadata bundleMetadata;

    public CodeTransparencyInjector(BundleMetadata bundleMetadata) {
        this.bundleMetadata = bundleMetadata;
    }

    public ModuleSplit inject(ModuleSplit split) {
        if (this.bundleMetadata.getModuleEntryForTransparencyFile().isPresent() && CodeTransparencyInjector.shouldPropagateTransparency(split)) {
            return split.toBuilder().addEntry(this.bundleMetadata.getModuleEntryForTransparencyFile().get()).build();
        }
        return split;
    }

    private static boolean shouldPropagateTransparency(ModuleSplit split) {
        return split.getSplitType() == ModuleSplit.SplitType.STANDALONE || split.isMasterSplit() && split.isBaseModuleSplit();
    }
}

