/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.BuildApksManagerComponent;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.ApkSigner;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.io.ZipEntrySourceFactory;
import com.android.tools.build.bundletool.io.ZipReader;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.CompressionLevel;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.PathMatcher;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.regex.Pattern;
import javax.inject.Inject;
import shadow.bundletool.com.android.zipflinger.BytesSource;
import shadow.bundletool.com.android.zipflinger.Entry;
import shadow.bundletool.com.android.zipflinger.ZipArchive;

final class ZipFlingerApkSerializerHelper
extends ApkSerializerHelper {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    private final ZipReader bundleZipReader;
    private final Config.BundleConfig bundleConfig;
    private final ApkSigner apkSigner;
    private final Aapt2Command aapt2;
    private final Version bundletoolVersion;
    private final boolean enableSparseEncoding;
    private final boolean useBundleCompression;

    @Inject
    ZipFlingerApkSerializerHelper(ZipReader bundleZipReader, Config.BundleConfig bundleConfig, Aapt2Command aapt2, Version bundletoolVersion, ApkSigner apkSigner, @BuildApksManagerComponent.UseBundleCompression boolean useBundleCompression) {
        this.bundleZipReader = bundleZipReader;
        this.bundleConfig = bundleConfig;
        this.aapt2 = aapt2;
        this.bundletoolVersion = bundletoolVersion;
        this.apkSigner = apkSigner;
        this.useBundleCompression = useBundleCompression;
        this.enableSparseEncoding = bundleConfig.getOptimizations().getResourceOptimizations().getSparseEncoding().equals((Object)Config.ResourceOptimizations.SparseEncoding.ENFORCED);
    }

    @Override
    public Path writeToZipFile(ModuleSplit split, Path outputPath) {
        try (TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());){
            this.writeToZipFile(split, outputPath, tempDir);
        }
        catch (IOException e4) {
            throw new UncheckedIOException(e4);
        }
        return outputPath;
    }

    private void writeToZipFile(ModuleSplit split, Path outputPath, TempDirectory tempDir) throws IOException {
        FilePreconditions.checkFileDoesNotExist(outputPath);
        FileUtils.createParentDirectories(outputPath);
        split = this.apkSigner.signEmbeddedApks(split);
        Path partialProtoApk = tempDir.getPath().resolve("proto.apk");
        this.writeProtoApk(split, partialProtoApk, tempDir);
        Path binaryApkPath = tempDir.getPath().resolve("binary.apk");
        if (this.enableSparseEncoding) {
            Path interimApk = tempDir.getPath().resolve("interim.apk");
            this.aapt2.convertApkProtoToBinary(partialProtoApk, interimApk);
            this.aapt2.optimizeToSparseResourceTables(interimApk, binaryApkPath);
        } else {
            this.aapt2.convertApkProtoToBinary(partialProtoApk, binaryApkPath);
        }
        Preconditions.checkState((boolean)Files.exists(binaryApkPath, new LinkOption[0]), (Object)"No APK created by aapt2 convert command.");
        CompressionManager compressionManager = new CompressionManager(split, this.bundleConfig);
        try (ZipArchive apkWriter = new ZipArchive(outputPath.toFile());){
            this.addEntriesConvertedByAapt2(apkWriter, binaryApkPath, compressionManager, tempDir);
            this.addRemainingEntries(apkWriter, split, compressionManager, tempDir);
        }
        this.apkSigner.signApk(outputPath, split);
    }

    private void addEntriesConvertedByAapt2(ZipArchive apkWriter, Path binaryApkPath, CompressionManager compressionManager, TempDirectory tempDir) throws IOException {
        try (ZipReader aapt2ApkZipReader = ZipReader.createFromFile(binaryApkPath);){
            ImmutableList sortedAapt2ApkEntries = ImmutableList.sortedCopyOf(Comparator.comparing(Entry::getName), (Iterable)aapt2ApkZipReader.getEntries().values());
            ZipEntrySourceFactory sourceFactory = new ZipEntrySourceFactory(aapt2ApkZipReader, tempDir);
            for (Entry entry : sortedAapt2ApkEntries) {
                String entryName = entry.getName();
                ZipPath pathInApk = ZipPath.create(entryName);
                CompressionLevel compressionLevel = compressionManager.shouldCompress(pathInApk) ? (entry.isCompressed() ? CompressionLevel.SAME_AS_SOURCE : CompressionLevel.BEST_COMPRESSION) : CompressionLevel.NO_COMPRESSION;
                apkWriter.add(sourceFactory.create(entry, pathInApk, compressionLevel).setAlignment(ZipFlingerApkSerializerHelper.getEntryAlignment(pathInApk, entry.isCompressed())));
            }
        }
    }

    private void addRemainingEntries(ZipArchive apkWriter, ModuleSplit split, CompressionManager compressionManager, TempDirectory tempDir) throws IOException {
        ImmutableList sortedEntries = ImmutableList.sortedCopyOf(Comparator.comparing(entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath())), split.getEntries());
        ZipEntrySourceFactory sourceFactory = new ZipEntrySourceFactory(this.bundleZipReader, tempDir);
        ImmutableMap<String, Entry> bundleEntries = this.bundleZipReader.getEntries();
        for (ModuleEntry moduleEntry : sortedEntries) {
            ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(moduleEntry.getPath());
            if (ZipFlingerApkSerializerHelper.requiresAapt2Conversion(pathInApk)) continue;
            boolean shouldCompress = compressionManager.shouldCompress(pathInApk);
            if (moduleEntry.getBundlePath().isPresent()) {
                ZipPath pathInBundle = moduleEntry.getBundlePath().get();
                Entry entry2 = (Entry)bundleEntries.get((Object)pathInBundle.toString());
                Preconditions.checkNotNull((Object)entry2, (String)"Could not find entry '%s'.", (Object)pathInBundle);
                CompressionLevel compressionLevel = shouldCompress ? (this.useBundleCompression && entry2.isCompressed() ? CompressionLevel.SAME_AS_SOURCE : CompressionLevel.DEFAULT_COMPRESSION) : CompressionLevel.NO_COMPRESSION;
                apkWriter.add(sourceFactory.create(entry2, pathInApk, compressionLevel).setAlignment(ZipFlingerApkSerializerHelper.getEntryAlignment(pathInApk, shouldCompress)));
                continue;
            }
            BytesSource bytesSource = new BytesSource(moduleEntry.getContent().read(), pathInApk.toString(), (int)(shouldCompress ? CompressionLevel.DEFAULT_COMPRESSION.getValue() : CompressionLevel.NO_COMPRESSION.getValue()));
            bytesSource.align(ZipFlingerApkSerializerHelper.getEntryAlignment(pathInApk, shouldCompress));
            apkWriter.add(bytesSource);
        }
    }

    private void writeProtoApk(ModuleSplit split, Path protoApkPath, TempDirectory tempDir) throws IOException {
        try (ZipArchive apkWriter = new ZipArchive(protoApkPath.toFile());){
            apkWriter.add(new BytesSource(split.getAndroidManifest().getManifestRoot().getProto().toByteArray(), "AndroidManifest.xml", (int)CompressionLevel.NO_COMPRESSION.getValue()));
            if (split.getResourceTable().isPresent()) {
                BytesSource bytesSource = new BytesSource(split.getResourceTable().get().toByteArray(), BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath().toString(), (int)CompressionLevel.NO_COMPRESSION.getValue());
                bytesSource.align(4L);
                apkWriter.add(bytesSource);
            }
            ImmutableMap<String, Entry> bundleEntriesByName = this.bundleZipReader.getEntries();
            ZipEntrySourceFactory sourceFactory = new ZipEntrySourceFactory(this.bundleZipReader, tempDir);
            for (ModuleEntry moduleEntry : split.getEntries()) {
                ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(moduleEntry.getPath());
                if (!ZipFlingerApkSerializerHelper.requiresAapt2Conversion(pathInApk)) continue;
                if (moduleEntry.getBundlePath().isPresent()) {
                    ZipPath pathInBundle = moduleEntry.getBundlePath().get();
                    Entry entry = (Entry)bundleEntriesByName.get(pathInBundle.toString());
                    Preconditions.checkNotNull((Object)entry, (String)"Could not find entry '%s'.", (Object)pathInBundle);
                    apkWriter.add(sourceFactory.create(entry, pathInApk, CompressionLevel.NO_COMPRESSION));
                    continue;
                }
                apkWriter.add(new BytesSource(moduleEntry.getContent().read(), pathInApk.toString(), (int)CompressionLevel.NO_COMPRESSION.getValue()));
            }
        }
    }

    private static long getEntryAlignment(ZipPath zipPath, boolean compressed) {
        if (compressed) {
            return 0L;
        }
        return zipPath.toString().endsWith(NATIVE_LIBRARIES_SUFFIX) ? 4096L : 4L;
    }

    private class CompressionManager {
        private final boolean uncompressNativeLibs;
        private final ImmutableSet<ZipPath> forceUncompressedEntries;
        private final ImmutableList<PathMatcher> uncompressedPathMatchers;

        CompressionManager(ModuleSplit split, Config.BundleConfig bundleConfig) {
            this.uncompressNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true) == false;
            this.forceUncompressedEntries = (ImmutableSet)split.getEntries().stream().filter(ModuleEntry::getForceUncompressed).map(entry -> ApkSerializerHelper.toApkEntryPath(entry.getPath())).collect(ImmutableSet.toImmutableSet());
            this.uncompressedPathMatchers = (ImmutableList)bundleConfig.getCompression().getUncompressedGlobList().stream().map(PathMatcher::createFromGlob).collect(ImmutableList.toImmutableList());
        }

        public boolean shouldCompress(ZipPath path) {
            if (this.uncompressedPathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path.toString()))) {
                return false;
            }
            if (path.toString().equals("resources.arsc")) {
                return false;
            }
            if (this.forceUncompressedEntries.contains((Object)path)) {
                return false;
            }
            if (!VersionGuardedFeature.NO_DEFAULT_UNCOMPRESS_EXTENSIONS.enabledForVersion(ZipFlingerApkSerializerHelper.this.bundletoolVersion) && ApkSerializerHelper.NO_COMPRESSION_EXTENSIONS.contains((Object)FileUtils.getFileExtension(path))) {
                return false;
            }
            return !this.uncompressNativeLibs || !NATIVE_LIBRARIES_PATTERN.matcher(path.toString()).matches();
        }
    }
}

