/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Base128OutputStream
extends BufferedOutputStream {
    public Base128OutputStream(@NotNull OutputStream stream) {
        super(stream);
    }

    public Base128OutputStream(@NotNull Path file2) throws IOException {
        super(Files.newOutputStream(file2, new OpenOption[0]));
    }

    public void writeInt(int value) throws IOException {
        do {
            int b11 = value & 0x7F;
            if ((value >>>= 7) != 0) {
                b11 |= 0x80;
            }
            super.write(b11);
        } while (value != 0);
    }

    public void writeLong(long value) throws IOException {
        do {
            int b11 = (int)value & 0x7F;
            if ((value >>>= 7) != 0L) {
                b11 |= 0x80;
            }
            super.write(b11);
        } while (value != 0L);
    }

    public void writeFloat(float value) throws IOException {
        this.writeFixed32(Float.floatToIntBits(value));
    }

    public void writeFixed32(int value) throws IOException {
        for (int shift = 0; shift < 32; shift += 8) {
            super.write(value >>> shift & 0xFF);
        }
    }

    public void writeString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeInt(0);
        } else {
            int len = str.length();
            this.writeInt(len + 1);
            for (int i11 = 0; i11 < len; ++i11) {
                this.writeChar(str.charAt(i11));
            }
        }
    }

    public void writeChar(char value) throws IOException {
        this.writeInt(value & 0xFFFF);
    }

    public void writeByte(byte value) throws IOException {
        super.write(value);
    }

    public void writeBytes(@NotNull byte[] bytes) throws IOException {
        this.writeInt(bytes.length);
        for (byte b11 : bytes) {
            this.writeByte(b11);
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeInt(value ? 1 : 0);
    }

    @Override
    @Deprecated
    public void write(int b11) {
        throw new UnsupportedOperationException("This method is disabled to prevent unintended accidental use. Please use writeByte or writeInt instead.");
    }
}

