/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.jar;

import java.io.IOException;
import java.io.OutputStream;
import java.util.SortedMap;
import java.util.jar.Attributes;
import shadow.bundletool.com.android.apksig.internal.jar.ManifestWriter;

public abstract class SignatureFileWriter {
    private SignatureFileWriter() {
    }

    public static void writeMainSection(OutputStream out, Attributes attributes) throws IOException {
        String signatureVersion = attributes.getValue(Attributes.Name.SIGNATURE_VERSION);
        if (signatureVersion == null) {
            throw new IllegalArgumentException("Mandatory " + Attributes.Name.SIGNATURE_VERSION + " attribute missing");
        }
        ManifestWriter.writeAttribute(out, Attributes.Name.SIGNATURE_VERSION, signatureVersion);
        if (attributes.size() > 1) {
            SortedMap<String, String> namedAttributes = ManifestWriter.getAttributesSortedByName(attributes);
            namedAttributes.remove(Attributes.Name.SIGNATURE_VERSION.toString());
            ManifestWriter.writeAttributes(out, namedAttributes);
        }
        SignatureFileWriter.writeSectionDelimiter(out);
    }

    public static void writeIndividualSection(OutputStream out, String name, Attributes attributes) throws IOException {
        ManifestWriter.writeIndividualSection(out, name, attributes);
    }

    public static void writeSectionDelimiter(OutputStream out) throws IOException {
        ManifestWriter.writeSectionDelimiter(out);
    }
}

