/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.androidtools.P7ZipCommand;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.io.MoreFiles;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Future;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.Sources;
import shadow.bundletool.com.android.zipflinger.ZipArchive;

interface Zipper {
    public static final long LARGE_ENTRY_SIZE_THRESHOLD_BYTES = SystemEnvironmentProvider.DEFAULT_PROVIDER.getProperty("bundletool.compression.newthread.entrysize").map(Long::parseLong).orElse(100000L);

    public void zip(Path var1, ImmutableMap<String, ByteSource> var2);

    public static Zipper uncompressedZip() {
        return (outputZip, entries) -> {
            try (ZipArchive archive = new ZipArchive(outputZip);){
                for (Map.Entry entry : entries.entrySet()) {
                    archive.add(Sources.from(((ByteSource)entry.getValue()).openStream(), (String)entry.getKey(), 0));
                }
            }
            catch (IOException e11) {
                throw new UncheckedIOException(e11);
            }
        };
    }

    public static Zipper compressedZip(ListeningExecutorService executorService, int compressionLevel) {
        return (outputZip, entries) -> {
            try (ZipArchive archive = new ZipArchive(outputZip);){
                ImmutableList.Builder largeSources = ImmutableList.builder();
                for (Map.Entry entry : entries.entrySet()) {
                    String path = (String)entry.getKey();
                    ByteSource content = (ByteSource)entry.getValue();
                    boolean smallEntry = (Boolean)content.sizeIfKnown().transform(size -> size < LARGE_ENTRY_SIZE_THRESHOLD_BYTES).or((Object)false);
                    if (smallEntry) {
                        archive.add(Sources.from(content.openStream(), path, compressionLevel));
                        continue;
                    }
                    largeSources.add((Object)executorService.submit(() -> Sources.from(content.openStream(), path, compressionLevel)));
                }
                for (Future source : Futures.inCompletionOrder((Iterable)largeSources.build())) {
                    archive.add((Source)Futures.getUnchecked((Future)source));
                }
            }
            catch (IOException e11) {
                throw new UncheckedIOException(e11);
            }
        };
    }

    public static Zipper compressedZip(P7ZipCommand p7ZipCommand, Path tempDirectory) {
        return (outputZip, entries) -> {
            try {
                FileUtils.createDirectories(tempDirectory);
                for (Map.Entry content : entries.entrySet()) {
                    ((ByteSource)content.getValue()).copyTo(MoreFiles.asByteSink((Path)tempDirectory.resolve((String)content.getKey()), (OpenOption[])new OpenOption[0]));
                }
                p7ZipCommand.compress(outputZip, tempDirectory);
            }
            catch (IOException e11) {
                throw new UncheckedIOException(e11);
            }
        };
    }
}

