/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;

public class FlightRecorder {
    private static final FlightRecorder INSTANCE = new FlightRecorder();
    private Deque<Object> records;
    private int sizeLimit;

    public static void initialize(int sizeLimit) {
        INSTANCE.setSizeLimit(sizeLimit);
    }

    public static void log(Object record) {
        INSTANCE.doLog(record);
    }

    public static void log(Supplier<?> lazyRecord) {
        INSTANCE.doLog(lazyRecord);
    }

    public static List<Object> getAndClear() {
        return INSTANCE.doGetAndClear();
    }

    public static void print() {
        for (Object record : FlightRecorder.getAndClear()) {
            System.out.println(record);
        }
    }

    private FlightRecorder() {
    }

    private synchronized void setSizeLimit(int sizeLimit) {
        if (sizeLimit > 0) {
            if (this.records == null) {
                this.records = new ArrayDeque<Object>(sizeLimit);
            } else {
                while (this.records.size() > sizeLimit) {
                    this.records.removeFirst();
                }
                ArrayDeque<Object> newRecords = new ArrayDeque<Object>(sizeLimit);
                newRecords.addAll(this.records);
                this.records = newRecords;
            }
        } else {
            this.records = null;
        }
        this.sizeLimit = sizeLimit;
    }

    private synchronized void doLog(Object record) {
        if (this.records != null) {
            if (this.records.size() >= this.sizeLimit) {
                this.records.removeFirst();
            }
            this.records.add(record);
        }
    }

    private synchronized void doLog(Supplier<?> lazyRecord) {
        if (this.records != null) {
            if (this.records.size() >= this.sizeLimit) {
                this.records.removeFirst();
            }
            this.records.add(lazyRecord.get());
        }
    }

    private synchronized List<Object> doGetAndClear() {
        if (this.records == null) {
            return ImmutableList.of();
        }
        ImmutableList contents = ImmutableList.copyOf(this.records);
        this.records.clear();
        return contents;
    }
}

