/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.archive;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.archive.ArchivedAndroidManifestUtils;
import com.android.tools.build.bundletool.archive.ArchivedResourcesHelper;
import com.android.tools.build.bundletool.io.ResourceReader;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceInjector;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.splitters.CodeTransparencyInjector;
import com.android.tools.build.bundletool.splitters.ResourceAnalyzer;
import com.android.tools.build.bundletool.transparency.BundleTransparencyCheckUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;

public final class ArchivedApksGenerator {
    private final ResourceReader resourceReader = new ResourceReader();
    private final ArchivedResourcesHelper archivedResourcesHelper = new ArchivedResourcesHelper(this.resourceReader);

    @Inject
    ArchivedApksGenerator() {
    }

    public ModuleSplit generateArchivedApk(AppBundle appBundle, Optional<String> customAppStorePackageName) throws IOException {
        this.validateRequest(appBundle);
        BundleModule baseModule = appBundle.getBaseModule();
        AndroidManifest archivedManifest = ArchivedAndroidManifestUtils.createArchivedManifest(baseModule.getAndroidManifest());
        Resources.ResourceTable archivedResourceTable = this.getArchivedResourceTable(appBundle, baseModule, archivedManifest);
        Optional<XmlProtoAttribute> iconAttribute = archivedManifest.getIconAttribute();
        Optional<XmlProtoAttribute> roundIconAttribute = archivedManifest.getRoundIconAttribute();
        ResourceInjector resourceInjector = new ResourceInjector(archivedResourceTable.toBuilder(), appBundle.getPackageName());
        ImmutableMap<String, Integer> extraResourceNameToIdMap = ArchivedResourcesHelper.injectExtraResources(resourceInjector, customAppStorePackageName, iconAttribute, roundIconAttribute);
        ImmutableMap<ZipPath, ByteSource> additionalResourcesByByteSource = this.archivedResourcesHelper.buildAdditionalResourcesByByteSourceMap((Integer)extraResourceNameToIdMap.get((Object)"com_android_vending_archive_icon_cloud_symbol"), (Integer)extraResourceNameToIdMap.get((Object)"com_android_vending_archive_icon_opacity_layer"), iconAttribute, roundIconAttribute, this.archivedResourcesHelper.findArchivedClassesDexPath(appBundle.getVersion(), BundleTransparencyCheckUtils.isTransparencyEnabled(appBundle)));
        archivedManifest = ArchivedAndroidManifestUtils.updateArchivedIconsAndTheme(archivedManifest, extraResourceNameToIdMap);
        ModuleSplit moduleSplit = ModuleSplit.forArchive(baseModule, archivedManifest, resourceInjector.build(), additionalResourcesByByteSource);
        if (BundleTransparencyCheckUtils.isTransparencyEnabled(appBundle)) {
            CodeTransparencyInjector codeTransparencyInjector = new CodeTransparencyInjector(appBundle);
            return codeTransparencyInjector.inject(moduleSplit);
        }
        return moduleSplit;
    }

    private void validateRequest(AppBundle appBundle) {
        Preconditions.checkNotNull((Object)appBundle);
        if (!appBundle.getStoreArchive().orElse(true).booleanValue()) {
            throw InvalidCommandException.builder().withInternalMessage("Archived APK cannot be generated when Store Archive configuration is disabled.").build();
        }
        if (appBundle.getBaseModule().getAndroidManifest().isHeadless()) {
            throw InvalidCommandException.builder().withInternalMessage("Archived APK can not be generated for applications without a launcher activity.").build();
        }
    }

    private Resources.ResourceTable getArchivedResourceTable(AppBundle appBundle, BundleModule bundleModule, AndroidManifest archivedManifest) throws IOException {
        Resources.ResourceTable.Builder archivedResourceTable = Resources.ResourceTable.newBuilder();
        if (bundleModule.getResourceTable().isPresent()) {
            ImmutableSet<ResourceId> referredResources = new ResourceAnalyzer(appBundle).findAllAppResourcesReachableFromManifest(archivedManifest);
            archivedResourceTable = ResourcesUtils.filterResourceTable(bundleModule.getResourceTable().get(), entry -> !referredResources.contains((Object)entry.getResourceId()), ResourceTableEntry::getEntry).toBuilder();
        }
        return archivedResourceTable.build();
    }
}

