/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.zipflinger;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import shadow.bundletool.com.android.zipflinger.EndOfCentralDirectory;
import shadow.bundletool.com.android.zipflinger.Ints;
import shadow.bundletool.com.android.zipflinger.Location;
import shadow.bundletool.com.android.zipflinger.ZipWriter;

public class Zip64Locator {
    private static final int SIGNATURE = 117853008;
    public static final int SIZE = 20;
    static final int TOTAL_NUMBER_DISK = 1;
    private Location location = Location.INVALID;
    private long offsetToEOCD64 = 0L;

    private Zip64Locator() {
    }

    public Location getLocation() {
        return this.location;
    }

    public long getOffsetToEOCD64() {
        return this.offsetToEOCD64;
    }

    public static Location write(ZipWriter writer, Location eocdLocation) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(117853008);
        buffer.putInt(0);
        buffer.putLong(eocdLocation.first);
        buffer.putInt(1);
        buffer.rewind();
        long position = writer.position();
        writer.write(buffer);
        return new Location(position, 20L);
    }

    static Zip64Locator find(FileChannel channel, EndOfCentralDirectory eocd) throws IOException {
        Zip64Locator locator = new Zip64Locator();
        Location locatorLocation = new Location(eocd.getLocation().first - 20L, 20L);
        long fileSize = channel.size();
        if (locatorLocation.last >= fileSize) {
            return locator;
        }
        if (locatorLocation.first < 0L) {
            return locator;
        }
        ByteBuffer locatorBuffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(locatorBuffer, locatorLocation.first);
        locatorBuffer.rewind();
        if (locator.parse(locatorBuffer)) {
            locator.location = locatorLocation;
        }
        return locator;
    }

    private boolean parse(ByteBuffer buffer) {
        int signature = buffer.getInt();
        if (signature != 117853008) {
            return false;
        }
        buffer.position(buffer.position() + 4);
        this.offsetToEOCD64 = Ints.ulongToLong(buffer.getLong());
        return true;
    }
}

