/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipUtils {
    public static Stream<ZipPath> allFileEntriesPaths(ZipFile zipFile) {
        return ZipUtils.allFileEntries(zipFile).map(zipEntry -> ZipPath.create(zipEntry.getName()));
    }

    public static Stream<? extends ZipEntry> allFileEntries(ZipFile zipFile) {
        return zipFile.stream().filter((Predicate<? extends ZipEntry>)Predicates.not(ZipEntry::isDirectory));
    }

    public static ZipFile openZipFile(Path path) {
        FilePreconditions.checkFileExistsAndReadable(path);
        try {
            return new ZipFile(path.toFile());
        }
        catch (IOException e11) {
            throw new UncheckedIOException(String.format("Error reading zip file '%s'.", path), e11);
        }
    }

    public static ZipPath convertBundleToModulePath(ZipPath bundlePath) {
        return bundlePath.subpath(1, bundlePath.getNameCount());
    }

    public static ByteSource asByteSource(ZipFile file, ZipEntry entry) {
        return new ZipEntryByteSource(file, entry);
    }

    private ZipUtils() {
    }

    private static final class ZipEntryByteSource
    extends ByteSource {
        private final ZipFile file;
        private final ZipEntry entry;

        ZipEntryByteSource(ZipFile file, ZipEntry entry) {
            this.file = (ZipFile)Preconditions.checkNotNull((Object)file);
            this.entry = (ZipEntry)Preconditions.checkNotNull((Object)entry);
        }

        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        public Optional<Long> sizeIfKnown() {
            return this.entry.getSize() == -1L ? Optional.absent() : Optional.of((Object)this.entry.getSize());
        }

        public String toString() {
            return "ZipUtils.asByteSource(" + this.file + ", " + this.entry + ")";
        }
    }
}

