/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.google.common.primitives.Ints;
import java.util.regex.Pattern;

public class DeviceTargetingUtils {
    private static final Pattern DEVICE_GROUP_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");

    public static void validateDeviceTierForAssetsDirectory(String directory, String tierName) {
        Integer tier = Ints.tryParse((String)tierName);
        if (tier == null || tier < 0) {
            throw InvalidBundleException.builder().withUserMessage("Device tiers should be non-negative integers. Found tier '%s' for directory '%s'.", tierName, directory).build();
        }
    }

    public static void validateDeviceGroupForConditionalModule(String groupName) {
        if (!DEVICE_GROUP_PATTERN.matcher(groupName).matches()) {
            throw InvalidBundleException.builder().withUserMessage("Device group names should start with a letter and contain only letters, numbers and underscores. Found group named '%s' in '<dist:%s>' element.", groupName, "device-group").build();
        }
    }

    private DeviceTargetingUtils() {
    }
}

