/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.$AutoValue_BundleMetadata;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.errorprone.annotations.Immutable;
import java.nio.file.Paths;
import java.util.Optional;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class BundleMetadata {
    public static final String BUNDLETOOL_NAMESPACE = "com.android.tools.build.bundletool";
    public static final String MAIN_DEX_LIST_FILE_NAME = "mainDexList.txt";
    public static final String OBFUSCATION_NAMESPACE = "shadow.bundletool.com.android.tools.build.obfuscation";
    public static final String PROGUARD_MAP_FILE_NAME = "proguard.map";
    public static final String TRANSPARENCY_SIGNED_FILE_NAME = "code_transparency_signed.jwt";

    public abstract ImmutableMap<ZipPath, ByteSource> getFileContentMap();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_BundleMetadata.Builder();
    }

    public Optional<ByteSource> getFileAsByteSource(String namespacedDir, String fileName) {
        return Optional.ofNullable(this.getFileContentMap().get((Object)BundleMetadata.toMetadataPath(namespacedDir, fileName)));
    }

    public Optional<ModuleEntry> getModuleEntryForSignedTransparencyFile() {
        return this.getFileAsByteSource(BUNDLETOOL_NAMESPACE, TRANSPARENCY_SIGNED_FILE_NAME).map(transparencySignedFileContent -> ModuleEntry.builder().setContent((ByteSource)transparencySignedFileContent).setFileLocation(ModuleEntry.ModuleEntryLocationInZipSource.create(Paths.get("", new String[0]), ZipPath.create("BUNDLE-METADATA").resolve(BUNDLETOOL_NAMESPACE).resolve(TRANSPARENCY_SIGNED_FILE_NAME))).setPath(ZipPath.create("META-INF").resolve(TRANSPARENCY_SIGNED_FILE_NAME)).build());
    }

    private static ZipPath toMetadataPath(String namespacedDir, String fileName) {
        return BundleMetadata.checkMetadataPath(ZipPath.create(namespacedDir).resolve(fileName));
    }

    private static ZipPath checkMetadataPath(ZipPath path) {
        Preconditions.checkArgument((path.getNameCount() >= 2 ? 1 : 0) != 0, (String)"The metadata file path '%s' is too shallow.", (Object)path);
        Preconditions.checkArgument((boolean)path.getName(0).toString().contains("."), (String)"Top-level directories for metadata files must be namespaced (eg. 'com.package'), got %s'.", (Object)path.getName(0));
        return path;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract ImmutableMap.Builder<ZipPath, ByteSource> fileContentMapBuilder();

        public Builder addFile(String namespacedDir, String fileName, ByteSource content) {
            return this.addFile(BundleMetadata.toMetadataPath(namespacedDir, fileName), content);
        }

        public Builder addFile(ZipPath path, ByteSource content) {
            this.fileContentMapBuilder().put((Object)BundleMetadata.checkMetadataPath(path), (Object)content);
            return this;
        }

        public abstract BundleMetadata build();
    }
}

