/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ShardedSystemSplits;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.splitters.BundleSharder;
import com.android.tools.build.bundletool.splitters.BundleSharderConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Optional;
import javax.inject.Inject;

public final class ShardedApksGenerator {
    private final Config.BundleConfig bundleConfig;
    private final BundleMetadata bundleMetadata;
    private final BuildApksCommand.ApkBuildMode apkBuildMode;
    private final ImmutableMap<OptimizationDimension, Config.SuffixStripping> suffixStrippings;
    private final Optional<SourceStamp> stampSource;
    private final BundleSharder bundleSharder;

    @Inject
    public ShardedApksGenerator(Config.BundleConfig bundleConfig, BundleMetadata bundleMetadata, BuildApksCommand.ApkBuildMode apkBuildMode, ImmutableMap<OptimizationDimension, Config.SuffixStripping> suffixStrippings, Optional<SourceStamp> stampSource, BundleSharder bundleSharder) {
        this.bundleConfig = bundleConfig;
        this.bundleMetadata = bundleMetadata;
        this.apkBuildMode = apkBuildMode;
        this.suffixStrippings = suffixStrippings;
        this.stampSource = stampSource;
        this.bundleSharder = bundleSharder;
    }

    public ImmutableList<ModuleSplit> generateSplits(ImmutableList<BundleModule> modules, ApkOptimizations apkOptimizations) {
        boolean strip64BitLibraries = this.bundleConfig.getOptimizations().getStandaloneConfig().getStrip64BitLibraries() && !this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.UNIVERSAL);
        BundleSharderConfiguration configuration = BundleSharderConfiguration.builder().setStrip64BitLibrariesFromShards(strip64BitLibraries).setSuffixStrippings(this.suffixStrippings).build();
        ImmutableList moduleSplits = ImmutableList.copyOf(ShardedApksGenerator.setVariantTargetingAndSplitType(this.bundleSharder.shardBundle(modules, apkOptimizations.getStandaloneDimensions(), this.bundleMetadata, configuration), ModuleSplit.SplitType.STANDALONE));
        if (this.stampSource.isPresent()) {
            return (ImmutableList)moduleSplits.stream().map(moduleSplit -> moduleSplit.writeSourceStampInManifest(this.stampSource.get().getSource(), SourceStamp.StampType.STAMP_TYPE_STANDALONE_APK)).collect(ImmutableList.toImmutableList());
        }
        return moduleSplits;
    }

    public ImmutableList<ModuleSplit> generateSystemSplits(ImmutableList<BundleModule> modules, ImmutableSet<BundleModuleName> modulesToFuse, ApkOptimizations apkOptimizations, Optional<Devices.DeviceSpec> deviceSpec) {
        BundleSharderConfiguration configuration = BundleSharderConfiguration.builder().setStrip64BitLibrariesFromShards(this.bundleConfig.getOptimizations().getStandaloneConfig().getStrip64BitLibraries()).setSuffixStrippings(this.suffixStrippings).setDeviceSpec(deviceSpec).build();
        ShardedSystemSplits shardedApks = this.bundleSharder.shardForSystemApps(modules, modulesToFuse, apkOptimizations.getSplitDimensions(), this.bundleMetadata, configuration);
        ModuleSplit fusedApk = ShardedApksGenerator.setVariantTargetingAndSplitType(shardedApks.getSystemImageSplit(), ModuleSplit.SplitType.SYSTEM).toBuilder().setMasterSplit(true).build();
        ImmutableList additionalSplitApks = (ImmutableList)shardedApks.getAdditionalSplits().stream().map(split -> split.toBuilder().setVariantTargeting(fusedApk.getVariantTargeting()).setSplitType(ModuleSplit.SplitType.SYSTEM).build()).collect(ImmutableList.toImmutableList());
        return ImmutableList.builder().add((Object)fusedApk).addAll((Iterable)additionalSplitApks).build();
    }

    public ImmutableList<ModuleSplit> generateApexSplits(ImmutableList<BundleModule> modules) {
        BundleSharderConfiguration configuration = BundleSharderConfiguration.builder().setStrip64BitLibrariesFromShards(this.bundleConfig.getOptimizations().getStandaloneConfig().getStrip64BitLibraries()).setSuffixStrippings(this.suffixStrippings).build();
        ImmutableList<ModuleSplit> shardedApexApks = this.bundleSharder.shardApexBundle((BundleModule)Iterables.getOnlyElement(modules), configuration);
        return ShardedApksGenerator.setVariantTargetingAndSplitType(shardedApexApks, ModuleSplit.SplitType.STANDALONE);
    }

    private static ImmutableList<ModuleSplit> setVariantTargetingAndSplitType(ImmutableList<ModuleSplit> standaloneApks, ModuleSplit.SplitType splitType) {
        return (ImmutableList)standaloneApks.stream().map(moduleSplit -> ShardedApksGenerator.setVariantTargetingAndSplitType(moduleSplit, splitType)).collect(ImmutableList.toImmutableList());
    }

    private static ModuleSplit setVariantTargetingAndSplitType(ModuleSplit moduleSplit, ModuleSplit.SplitType splitType) {
        return moduleSplit.toBuilder().setVariantTargeting(ShardedApksGenerator.standaloneApkVariantTargeting(moduleSplit)).setSplitType(splitType).build();
    }

    private static Targeting.VariantTargeting standaloneApkVariantTargeting(ModuleSplit standaloneApk) {
        Targeting.ApkTargeting apkTargeting = standaloneApk.getApkTargeting();
        Targeting.VariantTargeting.Builder variantTargeting = Targeting.VariantTargeting.newBuilder();
        if (apkTargeting.hasAbiTargeting()) {
            variantTargeting.setAbiTargeting(apkTargeting.getAbiTargeting());
        }
        if (apkTargeting.hasScreenDensityTargeting()) {
            variantTargeting.setScreenDensityTargeting(apkTargeting.getScreenDensityTargeting());
        }
        if (apkTargeting.hasMultiAbiTargeting()) {
            variantTargeting.setMultiAbiTargeting(apkTargeting.getMultiAbiTargeting());
        }
        if (apkTargeting.hasTextureCompressionFormatTargeting()) {
            variantTargeting.setTextureCompressionFormatTargeting(apkTargeting.getTextureCompressionFormatTargeting());
        }
        variantTargeting.setSdkVersionTargeting(ShardedApksGenerator.sdkVersionTargeting(standaloneApk));
        return variantTargeting.build();
    }

    private static Targeting.SdkVersionTargeting sdkVersionTargeting(ModuleSplit moduleSplit) {
        return Targeting.SdkVersionTargeting.newBuilder().addValue(TargetingProtoUtils.sdkVersionFrom(moduleSplit.getAndroidManifest().getEffectiveMinSdkVersion())).build();
    }
}

