/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import com.google.common.collect.ImmutableList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.CachedHashValueDexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.NamingState;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.RootSetBuilder;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

abstract class MemberNameMinifier<MemberType, StateType extends CachedHashValueDexItem> {
    protected final AppInfoWithSubtyping appInfo;
    protected final RootSetBuilder.RootSet rootSet;
    protected final ImmutableList<String> dictionary;
    protected final Map<MemberType, DexString> renaming = new IdentityHashMap<MemberType, DexString>();
    protected final Map<DexType, NamingState<StateType, ?>> states = new IdentityHashMap();
    protected final NamingState<StateType, ?> globalState;
    protected final boolean useUniqueMemberNames;

    MemberNameMinifier(AppInfoWithSubtyping appInfo, RootSetBuilder.RootSet rootSet, InternalOptions options) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.dictionary = options.proguardConfiguration.getObfuscationDictionary();
        this.globalState = NamingState.createRoot(appInfo.dexItemFactory, this.dictionary, this.getKeyTransform(options.proguardConfiguration));
        this.useUniqueMemberNames = options.proguardConfiguration.isUseUniqueClassMemberNames();
    }

    abstract Function<StateType, ?> getKeyTransform(ProguardConfiguration var1);

    protected NamingState<StateType, ?> computeStateIfAbsent(DexType type, Function<DexType, NamingState<StateType, ?>> f) {
        return this.useUniqueMemberNames ? this.globalState : this.states.computeIfAbsent(type, f);
    }

    protected NamingState<StateType, ?> getState(DexType type) {
        return this.useUniqueMemberNames ? this.globalState : this.states.get(type);
    }
}

