/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.dex;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import shadow.bundletool.com.android.tools.r8.dex.BaseFile;
import shadow.bundletool.com.android.tools.r8.dex.Constants;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.Origin;

public class VDexFile
extends BaseFile {
    private final int version;

    public VDexFile(Origin origin, InputStream stream) throws IOException {
        super(origin, ByteStreams.toByteArray((InputStream)stream));
        this.version = this.parseMagic(this.buffer);
        if (!VDexFile.supportedVersion(this.version)) {
            throw new CompilationError("Unsupported vdex file version " + this.version, origin);
        }
    }

    private static boolean supportedVersion(int versionNumber) {
        return 10 <= versionNumber && versionNumber <= 11;
    }

    private int parseMagic(ByteBuffer buffer) {
        int index = 0;
        for (byte prefixByte : Constants.VDEX_FILE_MAGIC_PREFIX) {
            if (buffer.get(index++) == prefixByte) continue;
            throw new CompilationError("VDex file has invalid header", this.origin);
        }
        byte[] version = new byte[4];
        for (int i = 0; i < 4; ++i) {
            if (!buffer.hasRemaining()) {
                throw new CompilationError("Truncated VDex file - unable to read version", this.origin);
            }
            version[i] = buffer.get(index++);
        }
        if (version[3] != 0) {
            throw new CompilationError("VDex file has invalid version number", this.origin);
        }
        int versionNumber = 0;
        for (int i = 0; i < 3; ++i) {
            if (48 > version[i] || version[i] > 57) {
                throw new CompilationError("VDex file has invalid version number", this.origin);
            }
            versionNumber = versionNumber * 10 + version[i] - 48;
        }
        return versionNumber;
    }

    public static int firstDexOffset(int numberOfDexFiles) {
        return 24 + numberOfDexFiles * 4;
    }

    @Override
    void setByteOrder() {
        int endian;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int dexFiles = this.buffer.getInt(8);
        if (dexFiles < 0 || dexFiles > 1000) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
            dexFiles = this.buffer.getInt(8);
            assert (dexFiles < 0 || dexFiles > 1000);
        }
        if ((endian = this.buffer.getInt(VDexFile.firstDexOffset(dexFiles) + 40)) != 305419896) {
            throw new CompilationError("Unable to determine endianess for reading vdex file.");
        }
    }

    int getVDexVersion() {
        return this.version;
    }
}

