/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.build.apkzlib.sign;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import shadow.bundletool.com.android.tools.build.apkzlib.utils.CachedSupplier;
import shadow.bundletool.com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.StoredEntry;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFile;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFileExtension;

public class ManifestGenerationExtension {
    private static final String META_INF_DIR = "META-INF";
    static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    @Nonnull
    private final String builtBy;
    @Nonnull
    private final String createdBy;
    @Nullable
    private ZFile zFile;
    @Nonnull
    private final Manifest manifest;
    @Nonnull
    private CachedSupplier<byte[]> manifestBytes;
    private boolean dirty;
    @Nullable
    private ZFileExtension extension;

    public ManifestGenerationExtension(@Nonnull String builtBy, @Nonnull String createdBy) {
        this.builtBy = builtBy;
        this.createdBy = createdBy;
        this.manifest = new Manifest();
        this.dirty = false;
        this.manifestBytes = new CachedSupplier<byte[]>(() -> {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            try {
                this.manifest.write(outBytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return outBytes.toByteArray();
        });
    }

    private void markDirty() {
        this.dirty = true;
        this.manifestBytes.reset();
    }

    public void register(@Nonnull ZFile zFile) throws IOException {
        Preconditions.checkState((this.extension == null ? 1 : 0) != 0, (Object)"register() has already been invoked.");
        this.zFile = zFile;
        this.rebuildManifest();
        this.extension = new ZFileExtension(){

            @Override
            @Nullable
            public IOExceptionRunnable beforeUpdate() {
                return () -> ManifestGenerationExtension.this.updateManifest();
            }
        };
        this.zFile.addZFileExtension(this.extension);
    }

    private void rebuildManifest() throws IOException {
        Attributes mainAttributes;
        String currentVersion;
        Verify.verifyNotNull((Object)this.zFile, (String)"zFile == null", (Object[])new Object[0]);
        StoredEntry manifestEntry = this.zFile.get(MANIFEST_NAME);
        if (manifestEntry != null) {
            this.manifest.clear();
            byte[] manifestBytes = manifestEntry.read();
            this.manifest.read(new ByteArrayInputStream(manifestBytes));
            this.manifestBytes.precomputed(manifestBytes);
        }
        if ((currentVersion = (mainAttributes = this.manifest.getMainAttributes()).getValue("Manifest-Version")) == null) {
            this.setMainAttribute("Manifest-Version", "1.0");
        } else if (!currentVersion.equals("1.0")) {
            throw new IOException("Unsupported manifest version: " + currentVersion + ".");
        }
        this.setMainAttribute("Built-By", this.builtBy);
        this.setMainAttribute("Created-By", this.createdBy);
    }

    private void setMainAttribute(@Nonnull String attribute, @Nonnull String value) {
        Attributes mainAttributes = this.manifest.getMainAttributes();
        String current = mainAttributes.getValue(attribute);
        if (!value.equals(current)) {
            mainAttributes.putValue(attribute, value);
            this.markDirty();
        }
    }

    private void updateManifest() throws IOException {
        Verify.verifyNotNull((Object)this.zFile, (String)"zFile == null", (Object[])new Object[0]);
        if (!this.dirty) {
            return;
        }
        this.zFile.add(MANIFEST_NAME, new ByteArrayInputStream(this.manifestBytes.get()));
        this.dirty = false;
    }
}

