/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.optimize;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class MemberRebindingAnalysis {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense lense;
    private final GraphLense.Builder builder = GraphLense.builder();

    public MemberRebindingAnalysis(Enqueuer.AppInfoWithLiveness appInfo, GraphLense lense) {
        assert (lense.isContextFree());
        this.appInfo = appInfo;
        this.lense = lense;
    }

    private DexMethod validTargetFor(DexMethod target, DexMethod original) {
        DexClass clazz = this.appInfo.definitionFor(target.getHolder());
        assert (clazz != null);
        if (!clazz.isLibraryClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.getHolder(), DexClass::lookupMethod) : this.firstLibraryClass(target.getHolder(), original.getHolder());
        return this.appInfo.dexItemFactory.createMethod(newHolder, original.proto, original.name);
    }

    private DexField validTargetFor(DexField target, DexField original, BiFunction<DexClass, DexField, DexEncodedField> lookup) {
        DexClass clazz = this.appInfo.definitionFor(target.getHolder());
        assert (clazz != null);
        if (!clazz.isLibraryClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.getHolder(), lookup) : this.firstLibraryClass(target.getHolder(), original.getHolder());
        return this.appInfo.dexItemFactory.createField(newHolder, original.type, original.name);
    }

    private <T> DexType firstLibraryClassForInterfaceTarget(T target, DexType current, BiFunction<DexClass, T, ?> lookup) {
        DexType matchingSuper;
        DexClass clazz = this.appInfo.definitionFor(current);
        Object potential = lookup.apply(clazz, (DexClass)target);
        if (potential != null) {
            return current;
        }
        if (clazz.superType != null && (matchingSuper = this.firstLibraryClassForInterfaceTarget(target, clazz.superType, lookup)) != null) {
            return clazz.isLibraryClass() ? current : matchingSuper;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexType matchingIface = this.firstLibraryClassForInterfaceTarget(target, iface, lookup);
            if (matchingIface == null) continue;
            return clazz.isLibraryClass() ? current : matchingIface;
        }
        return null;
    }

    private DexType firstLibraryClass(DexType top, DexType bottom) {
        assert (this.appInfo.definitionFor(top).isLibraryClass());
        DexClass searchClass = this.appInfo.definitionFor(bottom);
        while (!searchClass.isLibraryClass()) {
            searchClass = this.appInfo.definitionFor(searchClass.superType);
        }
        return searchClass.type;
    }

    private DexEncodedMethod classLookup(DexMethod method) {
        return this.appInfo.resolveMethodOnClass(method.getHolder(), method).asResultOfResolve();
    }

    private DexEncodedMethod interfaceLookup(DexMethod method) {
        return this.appInfo.resolveMethodOnInterface(method.getHolder(), method).asResultOfResolve();
    }

    private DexEncodedMethod anyLookup(DexMethod method) {
        return this.appInfo.resolveMethod(method.getHolder(), method).asResultOfResolve();
    }

    private void computeMethodRebinding(Set<DexMethod> methods, Function<DexMethod, DexEncodedMethod> lookupTarget) {
        for (DexMethod method : methods) {
            DexEncodedMethod target;
            DexClass originalClass;
            if (!(method = this.lense.lookupMethod(method, null)).getHolder().isClassType() || (originalClass = this.appInfo.definitionFor(method.holder)) == null || originalClass.isLibraryClass() || (target = lookupTarget.apply(method)) == null || target.method == method) continue;
            DexClass targetClass = this.appInfo.definitionFor(target.method.holder);
            if (!targetClass.accessFlags.isPublic() && target.accessFlags.isPublic()) {
                String packageDescriptor;
                String string = packageDescriptor = originalClass.accessFlags.isPublic() ? null : method.holder.getPackageDescriptor();
                if (packageDescriptor == null || !packageDescriptor.equals(targetClass.type.getPackageDescriptor())) {
                    DexProgramClass bridgeHolder = this.findBridgeMethodHolder(originalClass, targetClass, packageDescriptor);
                    assert (bridgeHolder != null);
                    DexEncodedMethod bridgeMethod = target.toForwardingMethod(bridgeHolder, this.appInfo.dexItemFactory);
                    bridgeHolder.addMethod(bridgeMethod);
                    assert (lookupTarget.apply(method) == bridgeMethod);
                    target = bridgeMethod;
                }
            }
            this.builder.map(method, this.validTargetFor(target.method, method));
        }
    }

    private DexProgramClass findBridgeMethodHolder(DexClass originalClass, DexClass targetClass, String packageDescriptor) {
        if (originalClass == targetClass || originalClass.isLibraryClass()) {
            return null;
        }
        DexProgramClass newHolder = null;
        if (originalClass.superType.isSubtypeOf(targetClass.type, this.appInfo)) {
            DexClass superClass = this.appInfo.definitionFor(originalClass.superType);
            newHolder = this.findBridgeMethodHolder(superClass, targetClass, packageDescriptor);
        } else {
            for (DexType iface : originalClass.interfaces.values) {
                if (!iface.isSubtypeOf(targetClass.type, this.appInfo)) continue;
                DexClass interfaceClass = this.appInfo.definitionFor(iface);
                newHolder = this.findBridgeMethodHolder(interfaceClass, targetClass, packageDescriptor);
            }
        }
        if (newHolder != null) {
            return newHolder;
        }
        if (originalClass.accessFlags.isPublic() || originalClass.type.getPackageDescriptor().equals(packageDescriptor)) {
            return originalClass.asProgramClass();
        }
        return null;
    }

    private void computeFieldRebinding(Set<DexField> fields, BiFunction<DexType, DexField, DexEncodedField> lookup, BiFunction<DexClass, DexField, DexEncodedField> lookupTargetOnClass) {
        for (DexField field : fields) {
            DexEncodedField target = lookup.apply((field = this.lense.lookupField(field, null)).getHolder(), field);
            if (target == null || target.field == field || !this.isVisibleFromOtherClasses(target)) continue;
            this.builder.map(field, this.validTargetFor(target.field, field, lookupTargetOnClass));
        }
    }

    private boolean isVisibleFromOtherClasses(DexEncodedField field) {
        if (!field.accessFlags.isPublic()) {
            return true;
        }
        return this.appInfo.definitionFor((DexType)field.field.getHolder()).accessFlags.isPublic();
    }

    public GraphLense run() {
        this.computeMethodRebinding(this.appInfo.virtualInvokes, this::classLookup);
        this.computeMethodRebinding(this.appInfo.interfaceInvokes, this::interfaceLookup);
        this.computeMethodRebinding(this.appInfo.superInvokes, this::anyLookup);
        this.computeMethodRebinding(this.appInfo.directInvokes, this::anyLookup);
        this.computeMethodRebinding(this.appInfo.staticInvokes, this::anyLookup);
        this.computeFieldRebinding((Set<DexField>)Sets.union(this.appInfo.staticFieldReads, this.appInfo.staticFieldWrites), this.appInfo::resolveFieldOn, DexClass::lookupField);
        this.computeFieldRebinding((Set<DexField>)Sets.union(this.appInfo.instanceFieldReads, this.appInfo.instanceFieldWrites), this.appInfo::resolveFieldOn, DexClass::lookupField);
        return this.builder.build(this.appInfo.dexItemFactory, this.lense);
    }
}

