/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.ArrayGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;

public class SwitchUtils {
    public static EnumSwitchInfo analyzeSwitchOverEnum(Instruction switchInsn, Enqueuer.AppInfoWithLiveness appInfo) {
        Instruction input = switchInsn.inValues().get((int)0).definition;
        if (input == null || !input.isArrayGet()) {
            return null;
        }
        ArrayGet arrayGet = input.asArrayGet();
        Instruction index = arrayGet.index().definition;
        if (index == null || !index.isInvokeVirtual()) {
            return null;
        }
        InvokeVirtual ordinalInvoke = index.asInvokeVirtual();
        DexMethod ordinalMethod = ordinalInvoke.getInvokedMethod();
        DexClass enumClass = appInfo.definitionFor(ordinalMethod.holder);
        DexItemFactory dexItemFactory = appInfo.dexItemFactory;
        if (enumClass == null || !enumClass.accessFlags.isEnum() && enumClass.type != dexItemFactory.enumType || ordinalMethod.name != dexItemFactory.ordinalMethodName || ordinalMethod.proto.returnType != dexItemFactory.intType || !ordinalMethod.proto.parameters.isEmpty()) {
            return null;
        }
        Instruction array = arrayGet.array().definition;
        if (array == null || !array.isStaticGet()) {
            return null;
        }
        StaticGet staticGet = array.asStaticGet();
        Int2ReferenceMap<DexField> indexMap = appInfo.getSwitchMapFor(staticGet.getField());
        if (indexMap == null || indexMap.isEmpty()) {
            return null;
        }
        DexType enumType = ((DexField)indexMap.values().iterator().next()).getHolder();
        Reference2IntMap<DexField> ordinalsMap = appInfo.getOrdinalsMapFor(enumType);
        if (ordinalsMap == null) {
            return null;
        }
        return new EnumSwitchInfo(enumType, ordinalInvoke, arrayGet, staticGet, indexMap, ordinalsMap);
    }

    public static final class EnumSwitchInfo {
        public final DexType enumClass;
        public final Instruction ordinalInvoke;
        public final Instruction arrayGet;
        public final Instruction staticGet;
        public final Int2ReferenceMap<DexField> indexMap;
        public final Reference2IntMap<DexField> ordinalsMap;

        private EnumSwitchInfo(DexType enumClass, Instruction ordinalInvoke, Instruction arrayGet, Instruction staticGet, Int2ReferenceMap<DexField> indexMap, Reference2IntMap<DexField> ordinalsMap) {
            this.enumClass = enumClass;
            this.ordinalInvoke = ordinalInvoke;
            this.arrayGet = arrayGet;
            this.staticGet = staticGet;
            this.indexMap = indexMap;
            this.ordinalsMap = ordinalsMap;
        }
    }
}

