/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.CompilationException;

class ExtractMarkerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: extractmarker [options] <input-files>", (Object)" where <input-files> are dex or vdex files", (Object)"  --no-other              # Only show information for D8 or R8 processed files.", (Object)"  --verbose               # More verbose output.", (Object)"  --summary               # Print summary at the end.", (Object)"  --csv                   # Output in CSV format.", (Object)"  --help                  # Print this message."));
    private final boolean printHelp;
    private final boolean includeOther;
    private final boolean verbose;
    private final boolean summary;
    private final boolean csv;
    private final List<Path> programFiles;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder parse(String[] args) throws CompilationException, IOException {
        Builder builder = ExtractMarkerCommand.builder();
        ExtractMarkerCommand.parse(args, builder);
        return builder;
    }

    private static void parse(String[] args, Builder builder) throws CompilationException, IOException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--no-other")) {
                builder.setIncludeOther(false);
                continue;
            }
            if (arg.equals("--verbose")) {
                builder.setVerbose(true);
                continue;
            }
            if (arg.equals("--summary")) {
                builder.setSummary(true);
                continue;
            }
            if (arg.equals("--csv")) {
                builder.setCSV(true);
                continue;
            }
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.startsWith("--")) {
                throw new CompilationException("Unknown option: " + arg);
            }
            builder.addProgramFile(Paths.get(arg, new String[0]));
        }
    }

    private ExtractMarkerCommand(boolean includeOther, boolean verbose, boolean summary, boolean csv, List<Path> programFiles) {
        this.printHelp = false;
        this.includeOther = includeOther;
        this.verbose = verbose;
        this.summary = summary;
        this.csv = csv;
        this.programFiles = programFiles;
    }

    private ExtractMarkerCommand(boolean printHelp) {
        this.printHelp = printHelp;
        this.includeOther = true;
        this.verbose = false;
        this.summary = false;
        this.csv = false;
        this.programFiles = ImmutableList.of();
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public List<Path> getProgramFiles() {
        return this.programFiles;
    }

    public boolean getIncludeOther() {
        return this.includeOther;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean getSummary() {
        return this.summary;
    }

    public boolean getCSV() {
        return this.csv;
    }

    public static class Builder {
        private boolean printHelp = false;
        private boolean includeOther = true;
        private boolean verbose;
        private boolean summary;
        private boolean csv;
        private final List<Path> programFiles = new ArrayList<Path>();

        public Builder setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this;
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public Builder setIncludeOther(boolean includeOther) {
            this.includeOther = includeOther;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setSummary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder setCSV(boolean csv) {
            this.csv = csv;
            return this;
        }

        public Builder addProgramFile(Path programFile) {
            this.programFiles.add(programFile);
            return this;
        }

        public ExtractMarkerCommand build() throws CompilationException, IOException {
            if (this.isPrintHelp()) {
                return new ExtractMarkerCommand(this.isPrintHelp());
            }
            return new ExtractMarkerCommand(this.includeOther, this.verbose, this.summary, this.csv, this.programFiles);
        }
    }
}

