/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.PackageTypeEntry;
import com.android.tools.build.bundletool.splitters.SplitterForOneTargetingDimension;
import com.android.tools.build.bundletool.targeting.ScreenDensitySelector;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ScreenDensityResourcesSplitter
extends SplitterForOneTargetingDimension {
    static final ImmutableSet<Targeting.ScreenDensity.DensityAlias> DEFAULT_DENSITY_BUCKETS = ImmutableSet.of((Object)((Object)Targeting.ScreenDensity.DensityAlias.LDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.MDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.HDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXXHDPI), (Object[])new Targeting.ScreenDensity.DensityAlias[]{Targeting.ScreenDensity.DensityAlias.TVDPI});
    private final ImmutableSet<Targeting.ScreenDensity.DensityAlias> densityBuckets;
    private final Version bundleVersion;

    public ScreenDensityResourcesSplitter(Version bundleVersion) {
        this(DEFAULT_DENSITY_BUCKETS, bundleVersion);
    }

    public ScreenDensityResourcesSplitter(ImmutableSet<Targeting.ScreenDensity.DensityAlias> densityBuckets, Version bundleVersion) {
        this.densityBuckets = densityBuckets;
        this.bundleVersion = bundleVersion;
    }

    @Override
    public ImmutableCollection<ModuleSplit> splitInternal(ModuleSplit split) {
        Optional<Resources.ResourceTable> resourceTable = split.getResourceTable();
        if (!resourceTable.isPresent() || resourceTable.get().equals((Object)Resources.ResourceTable.getDefaultInstance())) {
            return ImmutableList.of((Object)split);
        }
        ImmutableList.Builder splitsBuilder = new ImmutableList.Builder();
        for (Targeting.ScreenDensity.DensityAlias density : this.densityBuckets) {
            Resources.ResourceTable optimizedTable = this.filterResourceTableForDensity(resourceTable.get(), density);
            if (optimizedTable.equals((Object)Resources.ResourceTable.getDefaultInstance())) continue;
            ModuleSplit.Builder moduleSplitBuilder = split.toBuilder().setApkTargeting(split.getApkTargeting().toBuilder().setScreenDensityTargeting(Targeting.ScreenDensityTargeting.newBuilder().addValue(ScreenDensityResourcesSplitter.toScreenDensity(density)).addAllAlternatives((Iterable)ScreenDensityResourcesSplitter.allBut(this.densityBuckets, density).stream().map(ScreenDensityResourcesSplitter::toScreenDensity).collect(ImmutableList.toImmutableList()))).build()).setMasterSplit(false).setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(split.getEntries(), optimizedTable)).setResourceTable(optimizedTable);
            splitsBuilder.add((Object)moduleSplitBuilder.build());
        }
        ModuleSplit defaultResourcesSplit = this.getDefaultResourcesSplit(split, (ImmutableCollection<ModuleSplit>)splitsBuilder.build());
        return splitsBuilder.add((Object)defaultResourcesSplit).build();
    }

    private static Targeting.ScreenDensity toScreenDensity(Targeting.ScreenDensity.DensityAlias alias) {
        return Targeting.ScreenDensity.newBuilder().setDensityAlias(alias).build();
    }

    private ModuleSplit getDefaultResourcesSplit(ModuleSplit inputSplit, ImmutableCollection<ModuleSplit> densitySplits) {
        Resources.ResourceTable defaultSplitTable = this.getResourceTableForDefaultSplit(inputSplit, this.getClaimedConfigs((Iterable<ModuleSplit>)densitySplits));
        return inputSplit.toBuilder().setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(inputSplit.getEntries(), defaultSplitTable)).setResourceTable(defaultSplitTable).build();
    }

    private ImmutableMultimap<PackageTypeEntry, Resources.ConfigValue> getClaimedConfigs(Iterable<ModuleSplit> moduleSplits) {
        ImmutableMultimap.Builder result = new ImmutableMultimap.Builder();
        for (ModuleSplit moduleSplit : moduleSplits) {
            Preconditions.checkState((boolean)moduleSplit.getResourceTable().isPresent(), (Object)"Resource table not found in the density split.");
            for (Resources.Package pkg : moduleSplit.getResourceTable().get().getPackageList()) {
                for (Resources.Type type : pkg.getTypeList()) {
                    for (Resources.Entry entry : type.getEntryList()) {
                        for (Resources.ConfigValue configValue : entry.getConfigValueList()) {
                            result.put((Object)PackageTypeEntry.create((Resources.PackageOrBuilder)pkg, (Resources.TypeOrBuilder)type, (Resources.EntryOrBuilder)entry), (Object)configValue);
                        }
                    }
                }
            }
        }
        return result.build();
    }

    private Resources.ResourceTable getResourceTableForDefaultSplit(ModuleSplit split, ImmutableMultimap<PackageTypeEntry, Resources.ConfigValue> claimedConfigs) {
        Preconditions.checkArgument((boolean)split.getResourceTable().isPresent(), (Object)"Expected the split to contain Resource Table.");
        Resources.ResourceTable.Builder prunedTable = split.getResourceTable().get().toBuilder();
        for (Resources.Package.Builder packageBuilder : prunedTable.getPackageBuilderList()) {
            for (Resources.Type.Builder typeBuilder : packageBuilder.getTypeBuilderList()) {
                ArrayList<Resources.Entry> newEntries = new ArrayList<Resources.Entry>();
                for (Resources.Entry entry : typeBuilder.getEntryList()) {
                    ImmutableList allConfigsExceptClaimed = (ImmutableList)entry.getConfigValueList().stream().filter(configValue -> !claimedConfigs.containsEntry((Object)PackageTypeEntry.create((Resources.PackageOrBuilder)packageBuilder, (Resources.TypeOrBuilder)typeBuilder, (Resources.EntryOrBuilder)entry), configValue)).collect(ImmutableList.toImmutableList());
                    Resources.Entry.Builder newEntry = entry.toBuilder().clearConfigValue().addAllConfigValue((Iterable)allConfigsExceptClaimed);
                    if (newEntry.getConfigValueCount() <= 0) continue;
                    newEntries.add(newEntry.build());
                }
                typeBuilder.clearEntry().addAllEntry(newEntries);
            }
        }
        return prunedTable.build();
    }

    private Resources.ResourceTable filterResourceTableForDensity(Resources.ResourceTable input, Targeting.ScreenDensity.DensityAlias density) {
        return ResourcesUtils.filterResourceTable(input, type -> type.getName().equals("mipmap"), entry -> this.filterEntryForDensity((Resources.Entry)entry, density));
    }

    private Resources.Entry filterEntryForDensity(Resources.Entry initialEntry, Targeting.ScreenDensity.DensityAlias targetDensity) {
        Map configValuesByConfiguration = initialEntry.getConfigValueList().stream().filter(configValue -> !this.bundleVersion.isOlderThan(Version.of("0.4.0")) || configValue.getConfig().getDensity() != 0).collect(Collectors.groupingBy(configValue -> ScreenDensityResourcesSplitter.clearDensity(configValue.getConfig())));
        if (!this.bundleVersion.isOlderThan(Version.of("0.4.0"))) {
            configValuesByConfiguration = Maps.filterValues(configValuesByConfiguration, configValues -> configValues.size() > 1);
        }
        ImmutableList densityGroups = ImmutableList.copyOf(configValuesByConfiguration.values());
        ImmutableList<Resources.ConfigValue> valuesToKeep = this.pickBestDensityForEachGroup((ImmutableList<List<Resources.ConfigValue>>)densityGroups, targetDensity);
        return initialEntry.toBuilder().clearConfigValue().addAllConfigValue(valuesToKeep).build();
    }

    private ImmutableList<Resources.ConfigValue> pickBestDensityForEachGroup(ImmutableList<List<Resources.ConfigValue>> densityGroups, Targeting.ScreenDensity.DensityAlias densityAlias) {
        return (ImmutableList)densityGroups.stream().flatMap(group -> new ScreenDensitySelector().selectAllMatchingConfigValues((ImmutableList<Resources.ConfigValue>)ImmutableList.copyOf((Collection)group), densityAlias, ScreenDensityResourcesSplitter.allBut(this.densityBuckets, densityAlias)).stream()).collect(ImmutableList.toImmutableList());
    }

    private static Set<Targeting.ScreenDensity.DensityAlias> allBut(ImmutableSet<Targeting.ScreenDensity.DensityAlias> splitByDensities, Targeting.ScreenDensity.DensityAlias densityAlias) {
        return Sets.difference(splitByDensities, (Set)ImmutableSet.of((Object)((Object)densityAlias)));
    }

    private static ConfigurationOuterClass.Configuration clearDensity(ConfigurationOuterClass.Configuration source) {
        return source.toBuilder().clearDensity().build();
    }
}

