/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;

public class SplitApkSerializer {
    public static final String SPLIT_APKS_SUB_DIR = "splits";
    private final ApkSerializerHelper apkSerializerHelper;

    public SplitApkSerializer(Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfig, Config.Compression compression) {
        this.apkSerializerHelper = new ApkSerializerHelper(aapt2Command, signingConfig, compression);
    }

    public Commands.ApkDescription writeSplitToDisk(ModuleSplit split, Path outputDirectory) {
        Preconditions.checkState((boolean)Files.isDirectory(outputDirectory, new LinkOption[0]));
        String apkFileName = SplitApkSerializer.getApkFileName(split, split.getModuleName());
        String apkFileRelPath = ZipPath.create(SPLIT_APKS_SUB_DIR).resolve(apkFileName).toString();
        this.apkSerializerHelper.writeToZipFile(split, outputDirectory.resolve(apkFileRelPath));
        return Commands.ApkDescription.newBuilder().setPath(apkFileRelPath).setTargeting(split.getApkTargeting()).setSplitApkMetadata(Commands.SplitApkMetadata.newBuilder().setSplitId(split.getAndroidManifest().getSplitId().orElse("")).setIsMasterSplit(split.isMasterSplit())).build();
    }

    private static String getApkFileName(ModuleSplit apk, BundleModuleName moduleName) {
        String splitId = apk.getAndroidManifest().getSplitId().orElse("");
        String fileSuffix = apk.isMasterSplit() ? "master" : (String)Iterables.getLast(Arrays.asList(splitId.split("\\.")));
        return String.format("%s-%s.apk", moduleName.getName(), fileSuffix);
    }
}

