/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.io.TempFiles;
import com.android.tools.build.bundletool.io.ZipBuilder;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.WearApkLocator;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.files.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import shadow.bundletool.com.android.apksig.ApkSigner;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;
import shadow.bundletool.com.android.tools.build.apkzlib.zfile.ZFiles;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRule;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRules;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFile;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFileOptions;

final class ApkSerializerHelper {
    private static final String NATIVE_LIBRARIES_SUFFIX = ".so";
    private static final Pattern NATIVE_LIBRARIES_PATTERN = Pattern.compile("lib/[^/]+/[^/]+\\.so");
    private static final String SIGNER_CONFIG_NAME = "BNDLTOOL";
    @VisibleForTesting
    static final AlignmentRule APK_ALIGNMENT_RULE = AlignmentRules.compose(AlignmentRules.constantForSuffix(".so", 4096), AlignmentRules.constant(4));
    private static final com.google.common.base.Predicate<ZipPath> FILES_FOR_AAPT2 = path -> path.startsWith("res") || path.equals(BundleModule.RESOURCES_PROTO_PATH) || path.equals(ZipPath.create("AndroidManifest.xml"));
    private static final String BUILT_BY = "BundleTool";
    private static final String CREATED_BY = "BundleTool";
    private static final ImmutableSet<String> NO_COMPRESSION_EXTENSIONS = ImmutableSet.of((Object)"3g2", (Object)"3gp", (Object)"3gpp", (Object)"3gpp2", (Object)"aac", (Object)"amr", (Object[])new String[]{"awb", "gif", "imy", "jet", "jpeg", "jpg", "m4a", "m4v", "mid", "midi", "mkv", "mp2", "mp3", "mp4", "mpeg", "mpg", "ogg", "png", "rtttl", "smf", "wav", "webm", "wma", "wmv", "xmf"});
    private final Aapt2Command aapt2Command;
    private final Optional<SigningConfiguration> signingConfig;
    private final ImmutableList<PathMatcher> uncompressedPathMatchers;

    ApkSerializerHelper(Aapt2Command aapt2Command, Optional<SigningConfiguration> signingConfig, Config.Compression compression) {
        this.aapt2Command = aapt2Command;
        this.signingConfig = signingConfig;
        FileSystem fileSystem = FileSystems.getDefault();
        this.uncompressedPathMatchers = (ImmutableList)compression.getUncompressedGlobList().stream().map(glob -> "glob:" + glob).map(fileSystem::getPathMatcher).collect(ImmutableList.toImmutableList());
    }

    Path writeToZipFile(ModuleSplit split, Path outputPath) {
        TempFiles.withTempDirectory(tempDir -> this.writeToZipFile(split, outputPath, tempDir));
        return outputPath;
    }

    void writeToZipFile(ModuleSplit split, Path outputPath, Path tempDir) {
        FilePreconditions.checkFileDoesNotExist(outputPath);
        FileUtils.createParentDirectories(outputPath);
        Path partialProtoApk = tempDir.resolve("proto.apk");
        this.writeProtoApk(split, partialProtoApk, tempDir);
        Path binaryApk = tempDir.resolve("binary.apk");
        this.aapt2Command.convertApkProtoToBinary(partialProtoApk, binaryApk);
        Preconditions.checkState((boolean)Files.exists(binaryApk, new LinkOption[0]), (Object)"No APK created by aapt2 convert command.");
        int minSdkVersion = split.getAndroidManifest().getEffectiveMinSdkVersion();
        try (ZFile zOutputApk = ZFiles.apk(outputPath.toFile(), new ZFileOptions().setAlignmentRule(APK_ALIGNMENT_RULE).setCoverEmptySpaceUsingExtraField(true).setNoTimestamps(true), (PrivateKey)this.signingConfig.map(config -> config.getPrivateKey()).orElse(null), (ImmutableList<X509Certificate>)((ImmutableList)this.signingConfig.map(config -> config.getCertificates()).orElse(null)), true, true, "BundleTool", "BundleTool", minSdkVersion);
             ZFile zAapt2Files = new ZFile(binaryApk.toFile(), new ZFileOptions(), true);){
            zOutputApk.mergeFrom(zAapt2Files, (Predicate<String>)Predicates.alwaysFalse());
            this.addNonAapt2Files(zOutputApk, split);
            zOutputApk.sortZipContents();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to write APK file '%s'.", outputPath), e);
        }
    }

    private Path writeProtoApk(ModuleSplit split, Path outputPath, Path tempDir) {
        boolean extractNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true);
        Optional<ZipPath> wear1ApkPath = WearApkLocator.findEmbeddedWearApkPath(split);
        ZipBuilder zipBuilder = new ZipBuilder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = this.toApkEntryPath(entry.getPath());
            if (!FILES_FOR_AAPT2.apply((Object)pathInApk)) continue;
            ZipBuilder.EntryOption[] entryOptions = this.entryOptionForPath(pathInApk, !extractNativeLibs, entry.shouldCompress());
            if (this.signingConfig.isPresent() && wear1ApkPath.isPresent() && wear1ApkPath.get().equals(pathInApk)) {
                Path signedWearApk = ApkSerializerHelper.signWearApk(entry, this.signingConfig.get(), tempDir);
                zipBuilder.addFileFromDisk(pathInApk, signedWearApk.toFile(), entryOptions);
                continue;
            }
            zipBuilder.addFile(pathInApk, () -> entry.getContent(), entryOptions);
        }
        split.getResourceTable().ifPresent(resourceTable -> zipBuilder.addFileWithProtoContent(BundleModule.RESOURCES_PROTO_PATH, (MessageLite)resourceTable, new ZipBuilder.EntryOption[0]));
        zipBuilder.addFileWithProtoContent(ZipPath.create("AndroidManifest.xml"), (MessageLite)split.getAndroidManifest().getManifestRoot().getProto(), new ZipBuilder.EntryOption[0]);
        try {
            zipBuilder.writeTo(outputPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error while writing APK to file '%s'.", outputPath), e);
        }
        return outputPath;
    }

    private ZipBuilder.EntryOption[] entryOptionForPath(ZipPath path, boolean uncompressNativeLibs, boolean entryShouldCompress) {
        if (this.shouldCompress(path, uncompressNativeLibs, entryShouldCompress)) {
            return new ZipBuilder.EntryOption[0];
        }
        return new ZipBuilder.EntryOption[]{ZipBuilder.EntryOption.UNCOMPRESSED};
    }

    private boolean shouldCompress(ZipPath path, boolean uncompressNativeLibs, boolean entryShouldCompress) {
        if (this.uncompressedPathMatchers.stream().anyMatch(pathMatcher -> pathMatcher.matches(path))) {
            return false;
        }
        if (!entryShouldCompress) {
            return false;
        }
        if (NO_COMPRESSION_EXTENSIONS.contains((Object)FileUtils.getFileExtension(path))) {
            return false;
        }
        return !uncompressNativeLibs || !NATIVE_LIBRARIES_PATTERN.matcher(path.toString()).matches();
    }

    private void addNonAapt2Files(ZFile zFile, ModuleSplit split) throws IOException {
        boolean extractNativeLibs = split.getAndroidManifest().getExtractNativeLibsValue().orElse(true);
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = this.toApkEntryPath(entry.getPath());
            if (FILES_FOR_AAPT2.apply((Object)pathInApk)) continue;
            InputStream entryInputStream = entry.getContent();
            Throwable throwable = null;
            try {
                zFile.add(pathInApk.toString(), entryInputStream, this.shouldCompress(pathInApk, !extractNativeLibs, entry.shouldCompress()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (entryInputStream == null) continue;
                if (throwable != null) {
                    try {
                        entryInputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                entryInputStream.close();
            }
        }
    }

    private ZipPath toApkEntryPath(ZipPath pathInModule) {
        if (pathInModule.startsWith(BundleModule.DEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() == 2 ? 1 : 0) != 0, (String)"Only files directly in the dex directory are supported but found: %s.", (Object)pathInModule);
            FilePreconditions.checkFileHasExtension("File under dex/ directory", pathInModule, ".dex");
            return pathInModule.getFileName();
        }
        if (pathInModule.startsWith(BundleModule.ROOT_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the root directory are supported but found: %s", (Object)pathInModule);
            return pathInModule.subpath(1, pathInModule.getNameCount());
        }
        return pathInModule;
    }

    private static Path signWearApk(ModuleEntry wearApkEntry, SigningConfiguration signingConfig, Path tempDir) {
        try {
            ApkSigner.SignerConfig signerConfig = new ApkSigner.SignerConfig.Builder(SIGNER_CONFIG_NAME, signingConfig.getPrivateKey(), (List<X509Certificate>)signingConfig.getCertificates()).build();
            Path unsignedApk = tempDir.resolve("wear-unsigned.apk");
            Files.copy(wearApkEntry.getContent(), unsignedApk, new CopyOption[0]);
            Path signedApk = tempDir.resolve("wear-signed.apk");
            ApkSigner apkSigner = new ApkSigner.Builder((List<ApkSigner.SignerConfig>)ImmutableList.of((Object)signerConfig)).setInputApk(unsignedApk.toFile()).setOutputApk(signedApk.toFile()).build();
            apkSigner.sign();
            return signedApk;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | ApkFormatException e) {
            throw new ValidationException("Unable to sign the embedded Wear APK.", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to sign the embedded Wear APK.", e);
        }
    }
}

