/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_GetDeviceSpecCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.utils.EnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.SdkToolsLocator;
import com.android.tools.build.bundletool.utils.SystemEnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.auto.value.AutoValue;
import com.google.common.io.MoreFiles;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

@AutoValue
public abstract class GetDeviceSpecCommand {
    public static final String COMMAND_NAME = "get-device-spec";
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final String ANDROID_HOME_VARIABLE = "ANDROID_HOME";
    private static final EnvironmentVariableProvider DEFAULT_PROVIDER = new SystemEnvironmentVariableProvider();
    private static final String JSON_EXTENSION = "json";

    public abstract Path getAdbPath();

    public abstract Optional<String> getDeviceId();

    public abstract Path getOutputPath();

    abstract AdbServer getAdbServer();

    public static Builder builder() {
        return new AutoValue_GetDeviceSpecCommand.Builder();
    }

    public static GetDeviceSpecCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return GetDeviceSpecCommand.fromFlags(flags, DEFAULT_PROVIDER, adbServer);
    }

    public static GetDeviceSpecCommand fromFlags(ParsedFlags flags, EnvironmentVariableProvider environmentVariableProvider, AdbServer adbServer) {
        Builder builder = GetDeviceSpecCommand.builder().setAdbServer(adbServer).setOutputPath(OUTPUT_FLAG.getRequiredValue(flags));
        Optional<String> deviceSerialName = DEVICE_ID_FLAG.getValue(flags);
        if (deviceSerialName.isPresent()) {
            builder.setDeviceId(deviceSerialName.get());
        }
        Path adbPath = ADB_PATH_FLAG.getValue(flags).orElseGet(() -> (Path)environmentVariableProvider.getVariable(ANDROID_HOME_VARIABLE).flatMap(path -> new SdkToolsLocator().locateAdb(Paths.get(path, new String[0]))).orElseThrow(() -> new CommandExecutionException("Unable to determine the location of ADB. Please set the --adb flag or define ANDROID_HOME environment variable.")));
        builder.setAdbPath(adbPath);
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public Devices.DeviceSpec execute() {
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        Path pathToAdb = this.getAdbPath();
        FilePreconditions.checkFileExistsAndExecutable(pathToAdb);
        AdbServer adb = this.getAdbServer();
        adb.init(this.getAdbPath());
        Devices.DeviceSpec deviceSpec = new DeviceAnalyzer(adb).getDeviceSpec(this.getDeviceId());
        GetDeviceSpecCommand.writeDeviceSpecToFile(deviceSpec, this.getOutputPath());
        return deviceSpec;
    }

    private static void writeDeviceSpecToFile(Devices.DeviceSpec deviceSpec, Path outputFile) {
        try {
            Files.write(outputFile, JsonFormat.printer().print((MessageOrBuilder)deviceSpec).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error while writing the output file '%s'.", outputFile), e);
        }
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Writes out a JSON file containing the device specifications (i.e. features and properties) of the connected Android device.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(OUTPUT_FLAG.getName()).setExampleValue("device-spec.json").setDescription("Path to the output device spec file. Must have the .json extension.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s environment variable is set.", ANDROID_HOME_VARIABLE).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. Required when more than one device or emulator is connected.").build()).build();
    }

    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setAdbPath(Path var1);

        public abstract Builder setDeviceId(String var1);

        public abstract Builder setAdbServer(AdbServer var1);

        abstract GetDeviceSpecCommand autoBuild();

        public GetDeviceSpecCommand build() {
            GetDeviceSpecCommand command = this.autoBuild();
            if (!GetDeviceSpecCommand.JSON_EXTENSION.equals(MoreFiles.getFileExtension((Path)command.getOutputPath()))) {
                throw ValidationException.builder().withMessage("Flag --output should be the path where to generate the device spec file. Its extension must be '.json'.").build();
            }
            return command;
        }
    }
}

