/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.xml;

import com.android.tools.build.bundletool.model.exceptions.ValidationException;
import com.google.common.collect.ImmutableMap;
import java.util.StringJoiner;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathResolver {
    public static XPathResult resolve(Node node, XPathExpression xPathExpression) {
        try {
            NodeList nodeList = (NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET);
            return new XPathResult(nodeList);
        }
        catch (XPathExpressionException e4) {
            throw new ValidationException("Error evaluating the XPath expression.", e4);
        }
    }

    public static final class XPathResult {
        private static final ImmutableMap<Short, String> TYPE_VALUE_TO_NAME = ImmutableMap.builder().put((Object)2, (Object)"attribute").put((Object)4, (Object)"CDATA section").put((Object)8, (Object)"comment").put((Object)11, (Object)"document fragment").put((Object)9, (Object)"document").put((Object)10, (Object)"document type").put((Object)1, (Object)"element").put((Object)6, (Object)"entity").put((Object)5, (Object)"entity reference").put((Object)12, (Object)"notation").put((Object)7, (Object)"processing instruction").put((Object)3, (Object)"text").build();
        private final NodeList nodeList;

        private XPathResult(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        public String toString() {
            StringJoiner output = new StringJoiner(System.lineSeparator());
            block3: for (int i4 = 0; i4 < this.nodeList.getLength(); ++i4) {
                Node node = this.nodeList.item(i4);
                switch (node.getNodeType()) {
                    case 2: {
                        output.add(((Attr)node).getValue());
                        continue block3;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported XPath expression: cannot extract nodes of type: " + (String)TYPE_VALUE_TO_NAME.getOrDefault((Object)node.getNodeType(), (Object)"<unrecognized>"));
                    }
                }
            }
            return output.toString();
        }
    }
}

