/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.model.exceptions.ParseException;
import com.google.common.collect.ImmutableList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BadgingPackageNameParser {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile(".*? name='(.*?)'.*");

    private BadgingPackageNameParser() {
    }

    public static String parse(ImmutableList<String> badgingOutput) {
        String packageLine = badgingOutput.stream().filter(line -> line.trim().startsWith("package:")).findFirst().orElseThrow(() -> new ParseException(String.format("'package:' line not found in badging output\n: %s", String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)badgingOutput))));
        Matcher matcher = PACKAGE_NAME_PATTERN.matcher(packageLine);
        if (!matcher.matches()) {
            throw new ParseException(String.format("'name=' not found in package line: %s", packageLine));
        }
        return matcher.group(1);
    }
}

