/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;

public interface IROrdering {
    public Iterable<DexEncodedMethod> order(Iterable<DexEncodedMethod> var1);

    public Collection<DexEncodedMethod> order(Collection<DexEncodedMethod> var1);

    public static class NondeterministicIROrdering
    implements IROrdering {
        private static final NondeterministicIROrdering INSTANCE = new NondeterministicIROrdering();

        private NondeterministicIROrdering() {
        }

        public static NondeterministicIROrdering getInstance() {
            return INSTANCE;
        }

        public List<DexEncodedMethod> order(Iterable<DexEncodedMethod> methods) {
            ArrayList<DexEncodedMethod> toShuffle = Lists.newArrayList(methods);
            Collections.shuffle(toShuffle);
            return toShuffle;
        }

        public List<DexEncodedMethod> order(Collection<DexEncodedMethod> methods) {
            return this.order((Iterable)methods);
        }
    }

    public static class IdentityIROrdering
    implements IROrdering {
        private static final IdentityIROrdering INSTANCE = new IdentityIROrdering();

        private IdentityIROrdering() {
        }

        public static IdentityIROrdering getInstance() {
            return INSTANCE;
        }

        @Override
        public Iterable<DexEncodedMethod> order(Iterable<DexEncodedMethod> methods) {
            return methods;
        }

        @Override
        public Collection<DexEncodedMethod> order(Collection<DexEncodedMethod> methods) {
            return methods;
        }
    }
}

