/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.Optional;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;

public enum DexVersion {
    V35(35, new byte[]{48, 51, 53}),
    V37(37, new byte[]{48, 51, 55}),
    V38(38, new byte[]{48, 51, 56}),
    V39(39, new byte[]{48, 51, 57});

    private final int dexVersion;
    private final byte[] dexVersionBytes;

    private DexVersion(int dexVersion, byte[] dexVersionBytes) {
        this.dexVersion = dexVersion;
        this.dexVersionBytes = dexVersionBytes;
    }

    public int getIntValue() {
        return this.dexVersion;
    }

    public byte[] getBytes() {
        return this.dexVersionBytes;
    }

    public boolean matchesApiLevel(AndroidApiLevel androidApiLevel) {
        return DexVersion.getDexVersion((AndroidApiLevel)androidApiLevel).dexVersion >= this.dexVersion;
    }

    public static DexVersion getDexVersion(AndroidApiLevel androidApiLevel) {
        switch (androidApiLevel) {
            case Q: 
            case P: {
                return V39;
            }
            case O_MR1: 
            case O: {
                return V38;
            }
            case N_MR1: 
            case N: {
                return V37;
            }
            case B: 
            case B_1_1: 
            case C: 
            case D: 
            case E: 
            case E_0_1: 
            case E_MR1: 
            case F: 
            case G: 
            case G_MR1: 
            case H: 
            case H_MR1: 
            case H_MR2: 
            case I: 
            case I_MR1: 
            case J: 
            case J_MR1: 
            case J_MR2: 
            case K: 
            case K_WATCH: 
            case L: 
            case L_MR1: 
            case M: {
                return V35;
            }
        }
        throw new Unreachable("Unsupported api level " + (Object)((Object)androidApiLevel));
    }

    public static Optional<DexVersion> getDexVersion(int intValue) {
        switch (intValue) {
            case 35: {
                return Optional.of(V35);
            }
            case 37: {
                return Optional.of(V37);
            }
            case 38: {
                return Optional.of(V38);
            }
            case 39: {
                return Optional.of(V39);
            }
        }
        return Optional.empty();
    }

    public static Optional<DexVersion> getDexVersion(char b0, char b1, char b2) {
        if (b0 != '0' || b1 != '3' || b2 < '5' || '9' < b2) {
            return Optional.empty();
        }
        return DexVersion.getDexVersion(100 * (b0 - 48) + 10 * (b1 - 48) + (b2 - 48));
    }
}

