/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import shadow.bundletool.com.android.tools.r8.DataDirectoryResource;
import shadow.bundletool.com.android.tools.r8.DataEntryResource;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.ByteStreams;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.ArchiveEntryOrigin;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.shaking.FilteredClassPath;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.OneShotByteResource;
import shadow.bundletool.com.android.tools.r8.utils.ZipUtils;

@Keep
public class ArchiveResourceProvider
implements ProgramResourceProvider,
DataResourceProvider {
    private final Origin origin;
    private final FilteredClassPath archive;
    private final boolean ignoreDexInArchive;

    public static ArchiveResourceProvider fromArchive(Path archive, boolean ignoreDexInArchive) {
        return new ArchiveResourceProvider(FilteredClassPath.unfiltered(archive), ignoreDexInArchive);
    }

    ArchiveResourceProvider(FilteredClassPath archive, boolean ignoreDexInArchive) {
        assert (FileUtils.isArchive(archive.getPath()));
        this.origin = new PathOrigin(archive.getPath());
        this.archive = archive;
        this.ignoreDexInArchive = ignoreDexInArchive;
    }

    private List<ProgramResource> readArchive() throws IOException {
        ArrayList<ProgramResource> dexResources = new ArrayList<ProgramResource>();
        ArrayList<OneShotByteResource> classResources = new ArrayList<OneShotByteResource>();
        try (ZipFile zipFile = FileUtils.createZipFile(this.archive.getPath().toFile(), StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String name = entry.getName();
                    ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
                    if (!this.archive.matchesFile(name)) continue;
                    if (ZipUtils.isDexFile(name)) {
                        if (this.ignoreDexInArchive) continue;
                        OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.DEX, entryOrigin, ByteStreams.toByteArray(stream), null);
                        dexResources.add(resource);
                        continue;
                    }
                    if (!ZipUtils.isClassFile(name)) continue;
                    String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                    OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(descriptor));
                    classResources.add(resource);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    ArchiveResourceProvider.$closeResource(throwable, stream);
                }
            }
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e);
        }
        if (!dexResources.isEmpty() && !classResources.isEmpty()) {
            throw new CompilationError("Cannot create android app from an archive '" + this.archive + "' containing both DEX and Java-bytecode content");
        }
        return !dexResources.isEmpty() ? dexResources : classResources;
    }

    @Override
    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        try {
            return this.readArchive();
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
    }

    @Override
    public DataResourceProvider getDataResourceProvider() {
        return this;
    }

    @Override
    public void accept(DataResourceProvider.Visitor resourceBrowser) throws ResourceException {
        try (ZipFile zipFile = FileUtils.createZipFile(this.archive.getPath().toFile(), StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!this.archive.matchesFile(name) || this.isProgramResourceName(name)) continue;
                if (entry.isDirectory()) {
                    resourceBrowser.visit(DataDirectoryResource.fromZip(zipFile, entry));
                    continue;
                }
                resourceBrowser.visit(DataEntryResource.fromZip(zipFile, entry));
            }
        }
        catch (ZipException e) {
            throw new ResourceException(this.origin, (Throwable)new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e));
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)new CompilationError("I/O exception while reading '" + this.archive + "': " + e.getMessage(), e));
        }
    }

    private boolean isProgramResourceName(String name) {
        return ZipUtils.isClassFile(name) || ZipUtils.isDexFile(name) && !this.ignoreDexInArchive;
    }
}

