/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.com.google.common.io.ByteStreams;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.ArchiveEntryOrigin;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.OneShotByteResource;
import shadow.bundletool.com.android.tools.r8.utils.ZipUtils;

public class AarArchiveResourceProvider
implements ProgramResourceProvider {
    private final Origin origin;
    private final Path archive;

    public static AarArchiveResourceProvider fromArchive(Path archive) {
        return new AarArchiveResourceProvider(archive);
    }

    AarArchiveResourceProvider(Path archive) {
        assert (FileUtils.isArchive(archive));
        this.origin = new ArchiveEntryOrigin("classes.jar", new PathOrigin(archive));
        this.archive = archive;
    }

    private List<ProgramResource> readClassesJar(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        ArrayList<ProgramResource> resources = new ArrayList<ProgramResource>();
        while (null != (entry = stream.getNextEntry())) {
            String name = entry.getName();
            if (!ZipUtils.isClassFile(name)) continue;
            ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
            String descriptor = DescriptorUtils.guessTypeDescriptor(name);
            OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(descriptor));
            resources.add(resource);
        }
        return resources;
    }

    private List<ProgramResource> readArchive() throws IOException {
        List<ProgramResource> classResources = null;
        try (ZipFile zipFile = FileUtils.createZipFile(this.archive.toFile(), StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String name = entry.getName();
                    if (!name.equals("classes.jar")) continue;
                    try (ZipInputStream classesStream = new ZipInputStream(stream);){
                        classResources = this.readClassesJar(classesStream);
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    AarArchiveResourceProvider.$closeResource(throwable, stream);
                }
            }
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e);
        }
        return classResources == null ? Collections.emptyList() : classResources;
    }

    @Override
    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        try {
            return this.readArchive();
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
    }

    @Override
    public DataResourceProvider getDataResourceProvider() {
        return null;
    }
}

