/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.references.ClassReference;
import shadow.bundletool.com.android.tools.r8.references.MethodReference;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.references.TypeReference;
import shadow.bundletool.com.android.tools.r8.retrace.AmbiguousComparator;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceBase;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceClassResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceCommandLineResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceMethodResult;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceTypeResult;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class RetraceRegularExpression {
    private final RetraceBase retraceBase;
    private final List<String> stackTrace;
    private final DiagnosticsHandler diagnosticsHandler;
    private final String regularExpression;
    private static final int NO_MATCH = -1;
    private final RegularExpressionGroup[] groups = new RegularExpressionGroup[]{new TypeNameGroup(), new BinaryNameGroup(), new MethodNameGroup(), new FieldNameGroup(), new SourceFileGroup(), new LineNumberGroup(), new FieldOrReturnTypeGroup(), new MethodArgumentsGroup()};
    private static final String CAPTURE_GROUP_PREFIX = "captureGroup";
    private static final String javaIdentifierSegment = "[\\p{L}\\p{N}_\\p{Sc}]+";
    private static final String JAVA_TYPE_REGULAR_EXPRESSION = "([\\p{L}\\p{N}_\\p{Sc}]+\\.)*[\\p{L}\\p{N}_\\p{Sc}]+[\\[\\]]*";

    RetraceRegularExpression(RetraceBase retraceBase, List<String> stackTrace, DiagnosticsHandler diagnosticsHandler, String regularExpression) {
        this.retraceBase = retraceBase;
        this.stackTrace = stackTrace;
        this.diagnosticsHandler = diagnosticsHandler;
        this.regularExpression = regularExpression;
    }

    public RetraceCommandLineResult retrace() {
        ArrayList<RegularExpressionGroupHandler> handlers = new ArrayList<RegularExpressionGroupHandler>();
        String regularExpression = this.registerGroups(this.regularExpression, handlers);
        Pattern compiledPattern = Pattern.compile(regularExpression);
        ArrayList<String> result = new ArrayList<String>();
        for (String string : this.stackTrace) {
            boolean isAmbiguous;
            Matcher matcher = compiledPattern.matcher(string);
            List<RetraceString> retracedStrings = Lists.newArrayList(RetraceString.RetraceStringBuilder.create(string).build());
            if (matcher.matches()) {
                for (RegularExpressionGroupHandler handler : handlers) {
                    retracedStrings = handler.handleMatch(retracedStrings, matcher, this.retraceBase);
                }
            }
            if (retracedStrings.isEmpty()) {
                result.add(string);
                continue;
            }
            boolean bl = isAmbiguous = retracedStrings.size() > 1 && ((RetraceString)retracedStrings.get(0)).isAmbiguous;
            if (isAmbiguous) {
                retracedStrings.sort(new RetraceLineComparator());
            }
            ClassReference previousContext = null;
            for (RetraceString retracedString : retracedStrings) {
                String finalString = retracedString.getRetracedString();
                if (!isAmbiguous) {
                    result.add(finalString);
                    continue;
                }
                assert (retracedString.getClassContext() != null);
                ClassReference currentContext = retracedString.getClassContext().getClassReference();
                if (currentContext.equals(previousContext)) {
                    int firstNonWhitespaceCharacter = StringUtils.firstNonWhitespaceCharacter(finalString);
                    finalString = finalString.substring(0, firstNonWhitespaceCharacter) + "<OR> " + finalString.substring(firstNonWhitespaceCharacter);
                }
                previousContext = currentContext;
                result.add(finalString);
            }
        }
        return new RetraceCommandLineResult(result);
    }

    private String registerGroups(String regularExpression, List<RegularExpressionGroupHandler> handlers) {
        int currentIndex = 0;
        int captureGroupIndex = 0;
        while (currentIndex < regularExpression.length()) {
            RegularExpressionGroup firstGroup = null;
            int firstIndexFromCurrent = regularExpression.length();
            for (RegularExpressionGroup group : this.groups) {
                int nextIndexOf = regularExpression.indexOf(group.shortName(), currentIndex);
                if (nextIndexOf <= -1 || nextIndexOf >= firstIndexFromCurrent || nextIndexOf > 0 && regularExpression.charAt(nextIndexOf - 1) == '\\') continue;
                firstGroup = group;
                firstIndexFromCurrent = nextIndexOf;
            }
            if (firstGroup != null) {
                String captureGroupName = CAPTURE_GROUP_PREFIX + captureGroupIndex++;
                String patternToInsert = "(?<" + captureGroupName + ">" + firstGroup.subExpression() + ")";
                regularExpression = regularExpression.substring(0, firstIndexFromCurrent) + patternToInsert + regularExpression.substring(firstIndexFromCurrent + firstGroup.shortName().length());
                handlers.add(firstGroup.createHandler(captureGroupName));
                firstIndexFromCurrent += patternToInsert.length();
            }
            currentIndex = firstIndexFromCurrent;
        }
        return regularExpression;
    }

    private class MethodArgumentsGroup
    extends RegularExpressionGroup {
        private MethodArgumentsGroup() {
        }

        @Override
        String shortName() {
            return "%a";
        }

        @Override
        String subExpression() {
            return "((([\\p{L}\\p{N}_\\p{Sc}]+\\.)*[\\p{L}\\p{N}_\\p{Sc}]+[\\[\\]]*\\,)*([\\p{L}\\p{N}_\\p{Sc}]+\\.)*[\\p{L}\\p{N}_\\p{Sc}]+[\\[\\]]*)?";
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (strings, matcher, retraceBase) -> {
                if (matcher.start(captureGroup) == -1) {
                    return strings;
                }
                LinkedHashSet initialValue = new LinkedHashSet();
                initialValue.add(new ArrayList());
                Set allRetracedReferences = Arrays.stream(matcher.group(captureGroup).split(",")).map(String::trim).reduce(initialValue, (acc, typeName) -> {
                    String descriptor = DescriptorUtils.javaTypeToDescriptor(typeName);
                    if (!DescriptorUtils.isDescriptor(descriptor) && !"V".equals(descriptor)) {
                        return acc;
                    }
                    TypeReference typeReference = Reference.returnTypeFromDescriptor(descriptor);
                    LinkedHashSet retracedTypes = new LinkedHashSet();
                    retraceBase.retrace(typeReference).forEach(element -> {
                        for (List currentReferences : acc) {
                            ArrayList<TypeReference> newList = new ArrayList<TypeReference>(currentReferences);
                            newList.add(element.getTypeReference());
                            retracedTypes.add(newList);
                        }
                    });
                    return retracedTypes;
                }, (l1, l2) -> {
                    l1.addAll(l2);
                    return l1;
                });
                ArrayList<RetraceString> retracedStrings = new ArrayList<RetraceString>();
                for (RetraceString retraceString : strings) {
                    if (retraceString.getMethodContext() != null && !allRetracedReferences.contains(retraceString.getMethodContext().getMethodReference().getFormalTypes())) {
                        String formals = retraceString.getMethodContext().getMethodReference().getFormalTypes().stream().map(TypeReference::getTypeName).collect(Collectors.joining(","));
                        RetraceRegularExpression.this.diagnosticsHandler.info(new StringDiagnostic("Pruning " + retraceString.getRetracedString() + " from result because formals (" + formals + ") do not match result set."));
                        continue;
                    }
                    for (List retracedReferences : allRetracedReferences) {
                        retracedStrings.add(retraceString.transform().replaceInString(retracedReferences.stream().map(TypeReference::getTypeName).collect(Collectors.joining(",")), matcher.start(captureGroup), matcher.end(captureGroup)).build());
                    }
                }
                return retracedStrings;
            };
        }
    }

    private static class FieldOrReturnTypeGroup
    extends RegularExpressionGroup {
        private FieldOrReturnTypeGroup() {
        }

        @Override
        String shortName() {
            return "%t";
        }

        @Override
        String subExpression() {
            return RetraceRegularExpression.JAVA_TYPE_REGULAR_EXPRESSION;
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (strings, matcher, retraceBase) -> {
                if (matcher.start(captureGroup) == -1) {
                    return strings;
                }
                String typeName = matcher.group(captureGroup);
                String descriptor = DescriptorUtils.javaTypeToDescriptor(typeName);
                if (!DescriptorUtils.isDescriptor(descriptor) && !"V".equals(descriptor)) {
                    return strings;
                }
                TypeReference typeReference = Reference.returnTypeFromDescriptor(descriptor);
                ArrayList retracedStrings = new ArrayList();
                RetraceTypeResult retracedType = retraceBase.retrace(typeReference);
                for (RetraceString retraceString : strings) {
                    retracedType.forEach(element -> {
                        TypeReference retracedReference = element.getTypeReference();
                        retracedStrings.add(retraceString.transform().setTypeOrReturnTypeContext(retracedReference).replaceInString(retracedReference == null ? "void" : retracedReference.getTypeName(), matcher.start(captureGroup), matcher.end(captureGroup)).build());
                    });
                }
                return retracedStrings;
            };
        }
    }

    private class LineNumberGroup
    extends RegularExpressionGroup {
        private LineNumberGroup() {
        }

        @Override
        String shortName() {
            return "%l";
        }

        @Override
        String subExpression() {
            return "\\d*";
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (strings, matcher, retraceBase) -> {
                if (matcher.start(captureGroup) == -1) {
                    return strings;
                }
                String lineNumberAsString = matcher.group(captureGroup);
                int lineNumber = lineNumberAsString.isEmpty() ? -1 : Integer.parseInt(lineNumberAsString);
                ArrayList<RetraceString> retracedStrings = new ArrayList<RetraceString>();
                boolean seenRange = false;
                for (RetraceString retraceString : strings) {
                    RetraceMethodResult.Element methodContext = retraceString.methodContext;
                    if (methodContext == null || methodContext.getMethodReference().isUnknown()) {
                        retracedStrings.add(retraceString);
                        continue;
                    }
                    if (methodContext.hasNoLineNumberRange()) continue;
                    seenRange = true;
                    Set narrowedSet = methodContext.getRetraceMethodResult().narrowByLine(lineNumber).stream().map(RetraceMethodResult.Element::getMethodReference).collect(Collectors.toSet());
                    if (!narrowedSet.contains(methodContext.getMethodReference())) {
                        RetraceRegularExpression.this.diagnosticsHandler.info(new StringDiagnostic("Pruning " + retraceString.getRetracedString() + " from result because method is not defined on line number " + lineNumber));
                        continue;
                    }
                    if (!methodContext.containsMinifiedLineNumber(lineNumber)) {
                        RetraceRegularExpression.this.diagnosticsHandler.info(new StringDiagnostic("Pruning " + retraceString.getRetracedString() + " from result because method is not in range on line number " + lineNumber));
                        continue;
                    }
                    int originalLineNumber = methodContext.getOriginalLineNumber(lineNumber);
                    retracedStrings.add(retraceString.transform().setAmbiguous(false).setLineNumber(originalLineNumber).replaceInString(originalLineNumber + "", matcher.start(captureGroup), matcher.end(captureGroup)).build());
                }
                return seenRange ? retracedStrings : strings;
            };
        }
    }

    private static class SourceFileGroup
    extends RegularExpressionGroup {
        private SourceFileGroup() {
        }

        @Override
        String shortName() {
            return "%s";
        }

        @Override
        String subExpression() {
            return "(?:(\\w*[\\. ])?(\\w*)?)";
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (strings, matcher, retraceBase) -> {
                if (matcher.start(captureGroup) == -1) {
                    return strings;
                }
                String fileName = matcher.group(captureGroup);
                ArrayList<RetraceString> retracedStrings = new ArrayList<RetraceString>();
                for (RetraceString retraceString : strings) {
                    if (retraceString.classContext == null) {
                        retracedStrings.add(retraceString);
                        continue;
                    }
                    String newSourceFile = retraceString.getQualifiedContext() != null ? retraceBase.retraceSourceFile(retraceString.classContext.getClassReference(), fileName, retraceString.getQualifiedContext(), true) : retraceString.classContext.retraceSourceFile(fileName, retraceBase);
                    retracedStrings.add(retraceString.transform().setSource(fileName).replaceInString(newSourceFile, matcher.start(captureGroup), matcher.end(captureGroup)).build());
                }
                return retracedStrings;
            };
        }
    }

    private static class FieldNameGroup
    extends RegularExpressionGroup {
        private FieldNameGroup() {
        }

        @Override
        String shortName() {
            return "%f";
        }

        @Override
        String subExpression() {
            return RetraceRegularExpression.javaIdentifierSegment;
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (strings, matcher, retraceBase) -> {
                if (matcher.start(captureGroup) == -1) {
                    return strings;
                }
                String methodName = matcher.group(captureGroup);
                ArrayList<RetraceString> retracedStrings = new ArrayList<RetraceString>();
                for (RetraceString retraceString : strings) {
                    if (retraceString.getClassContext() == null) {
                        retracedStrings.add(retraceString);
                        continue;
                    }
                    retraceString.getClassContext().lookupField(methodName).forEach(element -> {
                        RetraceString.RetraceStringBuilder newRetraceString = retraceString.transform();
                        ClassReference existingClass = retraceString.getClassContext().getClassReference();
                        ClassReference holder = element.getFieldReference().getHolderClass();
                        if (holder != existingClass) {
                            newRetraceString.replaceInString(newRetraceString.classNameGroup.getClassName(existingClass), newRetraceString.classNameGroup.getClassName(holder)).setQualifiedContext(holder);
                        }
                        newRetraceString.replaceInString(element.getFieldReference().getFieldName(), matcher.start(captureGroup), matcher.end(captureGroup));
                        retracedStrings.add(newRetraceString.build());
                    });
                }
                return retracedStrings;
            };
        }
    }

    private static class MethodNameGroup
    extends RegularExpressionGroup {
        private MethodNameGroup() {
        }

        @Override
        String shortName() {
            return "%m";
        }

        @Override
        String subExpression() {
            return "(?:([\\p{L}\\p{N}_\\p{Sc}]+|\\<init\\>|\\<clinit\\>))";
        }

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (strings, matcher, retraceBase) -> {
                if (matcher.start(captureGroup) == -1) {
                    return strings;
                }
                String methodName = matcher.group(captureGroup);
                ArrayList<RetraceString> retracedStrings = new ArrayList<RetraceString>();
                for (RetraceString retraceString : strings) {
                    if (retraceString.classContext == null) {
                        retracedStrings.add(retraceString);
                        continue;
                    }
                    retraceString.getClassContext().lookupMethod(methodName).forEach(element -> {
                        MethodReference methodReference = element.getMethodReference();
                        if (retraceString.hasTypeOrReturnTypeContext()) {
                            if (methodReference.getReturnType() == null && retraceString.getTypeOrReturnTypeContext() != null) {
                                return;
                            }
                            if (methodReference.getReturnType() != null && !methodReference.getReturnType().equals(retraceString.getTypeOrReturnTypeContext())) {
                                return;
                            }
                        }
                        RetraceString.RetraceStringBuilder newRetraceString = retraceString.transform();
                        ClassReference existingClass = retraceString.getClassContext().getClassReference();
                        ClassReference holder = methodReference.getHolderClass();
                        if (holder != existingClass) {
                            newRetraceString.replaceInString(newRetraceString.classNameGroup.getClassName(existingClass), newRetraceString.classNameGroup.getClassName(holder)).setQualifiedContext(holder);
                        }
                        newRetraceString.setMethodContext((RetraceMethodResult.Element)element).setAmbiguous(element.getRetraceMethodResult().isAmbiguous()).replaceInString(methodReference.getMethodName(), matcher.start(captureGroup), matcher.end(captureGroup));
                        retracedStrings.add(newRetraceString.build());
                    });
                }
                return retracedStrings;
            };
        }
    }

    private static class BinaryNameGroup
    extends ClassNameGroup {
        private BinaryNameGroup() {
        }

        @Override
        String shortName() {
            return "%C";
        }

        @Override
        String subExpression() {
            return "(?:[\\p{L}\\p{N}_\\p{Sc}]+\\/)*[\\p{L}\\p{N}_\\p{Sc}]+";
        }

        @Override
        String getClassName(ClassReference classReference) {
            return classReference.getBinaryName();
        }

        @Override
        ClassReference classFromMatch(String match) {
            return Reference.classFromBinaryName(match);
        }
    }

    private static class TypeNameGroup
    extends ClassNameGroup {
        private TypeNameGroup() {
        }

        @Override
        String shortName() {
            return "%c";
        }

        @Override
        String subExpression() {
            return "([\\p{L}\\p{N}_\\p{Sc}]+\\.)*[\\p{L}\\p{N}_\\p{Sc}]+";
        }

        @Override
        String getClassName(ClassReference classReference) {
            return classReference.getTypeName();
        }

        @Override
        ClassReference classFromMatch(String match) {
            return Reference.classFromTypeName(match);
        }
    }

    private static abstract class ClassNameGroup
    extends RegularExpressionGroup {
        private ClassNameGroup() {
        }

        abstract String getClassName(ClassReference var1);

        abstract ClassReference classFromMatch(String var1);

        @Override
        RegularExpressionGroupHandler createHandler(String captureGroup) {
            return (strings, matcher, retraceBase) -> {
                if (matcher.start(captureGroup) == -1) {
                    return strings;
                }
                String typeName = matcher.group(captureGroup);
                RetraceClassResult retraceResult = retraceBase.retrace(this.classFromMatch(typeName));
                ArrayList retracedStrings = new ArrayList();
                for (RetraceString retraceString : strings) {
                    retraceResult.forEach(element -> retracedStrings.add(retraceString.transform().setClassContext((RetraceClassResult.Element)element, this).setMethodContext(null).replaceInString(this.getClassName(element.getClassReference()), matcher.start(captureGroup), matcher.end(captureGroup)).build()));
                }
                return retracedStrings;
            };
        }
    }

    private static abstract class RegularExpressionGroup {
        private RegularExpressionGroup() {
        }

        abstract String shortName();

        abstract String subExpression();

        abstract RegularExpressionGroupHandler createHandler(String var1);
    }

    private static interface RegularExpressionGroupHandler {
        public List<RetraceString> handleMatch(List<RetraceString> var1, Matcher var2, RetraceBase var3);
    }

    static class RetraceString {
        private final RetraceClassResult.Element classContext;
        private final ClassNameGroup classNameGroup;
        private final ClassReference qualifiedContext;
        private final RetraceMethodResult.Element methodContext;
        private final TypeReference typeOrReturnTypeContext;
        private final boolean hasTypeOrReturnTypeContext;
        private final String retracedString;
        private final int adjustedIndex;
        private final boolean isAmbiguous;
        private final int lineNumber;
        private final String source;

        private RetraceString(RetraceClassResult.Element classContext, ClassNameGroup classNameGroup, ClassReference qualifiedContext, RetraceMethodResult.Element methodContext, TypeReference typeOrReturnTypeContext, boolean hasTypeOrReturnTypeContext, String retracedString, int adjustedIndex, boolean isAmbiguous, int lineNumber, String source) {
            this.classContext = classContext;
            this.classNameGroup = classNameGroup;
            this.qualifiedContext = qualifiedContext;
            this.methodContext = methodContext;
            this.typeOrReturnTypeContext = typeOrReturnTypeContext;
            this.hasTypeOrReturnTypeContext = hasTypeOrReturnTypeContext;
            this.retracedString = retracedString;
            this.adjustedIndex = adjustedIndex;
            this.isAmbiguous = isAmbiguous;
            this.lineNumber = lineNumber;
            this.source = source;
        }

        String getRetracedString() {
            return this.retracedString;
        }

        boolean hasTypeOrReturnTypeContext() {
            return this.hasTypeOrReturnTypeContext;
        }

        RetraceClassResult.Element getClassContext() {
            return this.classContext;
        }

        RetraceMethodResult.Element getMethodContext() {
            return this.methodContext;
        }

        TypeReference getTypeOrReturnTypeContext() {
            return this.typeOrReturnTypeContext;
        }

        public ClassReference getQualifiedContext() {
            return this.qualifiedContext;
        }

        RetraceStringBuilder transform() {
            return RetraceStringBuilder.create(this);
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getSource() {
            return this.source;
        }

        static class RetraceStringBuilder {
            private RetraceClassResult.Element classContext;
            private ClassNameGroup classNameGroup;
            private ClassReference qualifiedContext;
            private RetraceMethodResult.Element methodContext;
            private TypeReference typeOrReturnTypeContext;
            private boolean hasTypeOrReturnTypeContext;
            private String retracedString;
            private int adjustedIndex;
            private boolean isAmbiguous;
            private int lineNumber;
            private String source;
            private int maxReplaceStringIndex = -1;

            private RetraceStringBuilder(RetraceClassResult.Element classContext, ClassNameGroup classNameGroup, ClassReference qualifiedContext, RetraceMethodResult.Element methodContext, TypeReference typeOrReturnTypeContext, boolean hasTypeOrReturnTypeContext, String retracedString, int adjustedIndex, boolean isAmbiguous, int lineNumber, String source) {
                this.classContext = classContext;
                this.classNameGroup = classNameGroup;
                this.qualifiedContext = qualifiedContext;
                this.methodContext = methodContext;
                this.typeOrReturnTypeContext = typeOrReturnTypeContext;
                this.hasTypeOrReturnTypeContext = hasTypeOrReturnTypeContext;
                this.retracedString = retracedString;
                this.adjustedIndex = adjustedIndex;
                this.isAmbiguous = isAmbiguous;
                this.lineNumber = lineNumber;
                this.source = source;
            }

            static RetraceStringBuilder create(String string) {
                return new RetraceStringBuilder(null, null, null, null, null, false, string, 0, false, 0, "");
            }

            static RetraceStringBuilder create(RetraceString string) {
                return new RetraceStringBuilder(string.classContext, string.classNameGroup, string.qualifiedContext, string.methodContext, string.typeOrReturnTypeContext, string.hasTypeOrReturnTypeContext, string.retracedString, string.adjustedIndex, string.isAmbiguous, string.lineNumber, string.source);
            }

            RetraceStringBuilder setClassContext(RetraceClassResult.Element classContext, ClassNameGroup classNameGroup) {
                this.classContext = classContext;
                this.classNameGroup = classNameGroup;
                return this;
            }

            RetraceStringBuilder setMethodContext(RetraceMethodResult.Element methodContext) {
                this.methodContext = methodContext;
                return this;
            }

            RetraceStringBuilder setTypeOrReturnTypeContext(TypeReference typeOrReturnTypeContext) {
                this.hasTypeOrReturnTypeContext = true;
                this.typeOrReturnTypeContext = typeOrReturnTypeContext;
                return this;
            }

            RetraceStringBuilder setQualifiedContext(ClassReference qualifiedContext) {
                this.qualifiedContext = qualifiedContext;
                return this;
            }

            RetraceStringBuilder setAmbiguous(boolean isAmbiguous) {
                this.isAmbiguous = isAmbiguous;
                return this;
            }

            RetraceStringBuilder setLineNumber(int lineNumber) {
                this.lineNumber = lineNumber;
                return this;
            }

            RetraceStringBuilder setSource(String source) {
                this.source = source;
                return this;
            }

            RetraceStringBuilder replaceInString(String oldString, String newString) {
                int oldStringStartIndex = this.retracedString.indexOf(oldString);
                assert (oldStringStartIndex > -1);
                int oldStringEndIndex = oldStringStartIndex + oldString.length();
                return this.replaceInStringRaw(newString, oldStringStartIndex, oldStringEndIndex);
            }

            RetraceStringBuilder replaceInString(String newString, int originalFrom, int originalTo) {
                return this.replaceInStringRaw(newString, originalFrom + this.adjustedIndex, originalTo + this.adjustedIndex);
            }

            RetraceStringBuilder replaceInStringRaw(String newString, int from, int to) {
                assert (from <= to);
                assert (from > this.maxReplaceStringIndex);
                String prefix = this.retracedString.substring(0, from);
                String postFix = this.retracedString.substring(to);
                this.retracedString = prefix + newString + postFix;
                this.adjustedIndex = this.adjustedIndex + newString.length() - (to - from);
                this.maxReplaceStringIndex = prefix.length() + newString.length();
                return this;
            }

            RetraceString build() {
                return new RetraceString(this.classContext, this.classNameGroup, this.qualifiedContext, this.methodContext, this.typeOrReturnTypeContext, this.hasTypeOrReturnTypeContext, this.retracedString, this.adjustedIndex, this.isAmbiguous, this.lineNumber, this.source);
            }
        }
    }

    static class RetraceLineComparator
    extends AmbiguousComparator<RetraceString> {
        RetraceLineComparator() {
            super((line, t) -> {
                switch (t) {
                    case CLASS: {
                        return line.getClassContext().getClassReference().getTypeName();
                    }
                    case METHOD: {
                        return line.getMethodContext().getMethodReference().getMethodName();
                    }
                    case SOURCE: {
                        return line.getSource();
                    }
                    case LINE: {
                        return line.getLineNumber() + "";
                    }
                }
                assert (false);
                throw new RuntimeException("Comparator key is unknown");
            });
        }
    }
}

