/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class RetraceCommand {
    final boolean isVerbose;
    final String regularExpression;
    final DiagnosticsHandler diagnosticsHandler;
    final ProguardMapProducer proguardMapProducer;
    final List<String> stackTrace;
    final Consumer<List<String>> retracedStackTraceConsumer;

    private RetraceCommand(boolean isVerbose, String regularExpression, DiagnosticsHandler diagnosticsHandler, ProguardMapProducer proguardMapProducer, List<String> stackTrace, Consumer<List<String>> retracedStackTraceConsumer) {
        this.isVerbose = isVerbose;
        this.regularExpression = regularExpression;
        this.diagnosticsHandler = diagnosticsHandler;
        this.proguardMapProducer = proguardMapProducer;
        this.stackTrace = stackTrace;
        this.retracedStackTraceConsumer = retracedStackTraceConsumer;
        assert (this.diagnosticsHandler != null);
        assert (this.proguardMapProducer != null);
        assert (this.stackTrace != null);
        assert (this.retracedStackTraceConsumer != null);
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder builder() {
        return new Builder(new DiagnosticsHandler(){});
    }

    @Keep
    public static interface ProguardMapProducer {
        public String get() throws IOException;
    }

    public static class Builder {
        private boolean isVerbose;
        private final DiagnosticsHandler diagnosticsHandler;
        private ProguardMapProducer proguardMapProducer;
        private String regularExpression;
        private List<String> stackTrace;
        private Consumer<List<String>> retracedStackTraceConsumer;

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            this.diagnosticsHandler = diagnosticsHandler;
        }

        public Builder setVerbose(boolean verbose) {
            this.isVerbose = verbose;
            return this;
        }

        public Builder setProguardMapProducer(ProguardMapProducer producer) {
            this.proguardMapProducer = producer;
            return this;
        }

        public Builder setRegularExpression(String regularExpression) {
            this.regularExpression = regularExpression;
            return this;
        }

        public Builder setStackTrace(List<String> stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Builder setRetracedStackTraceConsumer(Consumer<List<String>> consumer) {
            this.retracedStackTraceConsumer = consumer;
            return this;
        }

        public RetraceCommand build() {
            if (this.diagnosticsHandler == null) {
                throw new RuntimeException("DiagnosticsHandler not specified");
            }
            if (this.proguardMapProducer == null) {
                throw new RuntimeException("ProguardMapSupplier not specified");
            }
            if (this.stackTrace == null) {
                throw new RuntimeException("StackTrace not specified");
            }
            if (this.retracedStackTraceConsumer == null) {
                throw new RuntimeException("RetracedStackConsumer not specified");
            }
            if (this.isVerbose && this.regularExpression != null) {
                this.diagnosticsHandler.warning(new StringDiagnostic("Retrace does not support verbose output when a regular expression is specified"));
            }
            return new RetraceCommand(this.isVerbose, this.regularExpression, this.diagnosticsHandler, this.proguardMapProducer, this.stackTrace, this.retracedStackTraceConsumer);
        }
    }
}

